/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChain;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;

public class RequestContextListenerChainBuilder {
    private final PriorityQueue<RequestContextListener> listeners = new PriorityQueue<RequestContextListener>(10, RequestContextListenerChain.naturalOrdering);
    private final Collection<Class<? extends RequestContextListener>> listenerClassesToRemove = new HashSet<Class<? extends RequestContextListener>>();
    private boolean withoutDefaultListeners = false;

    @Nonnull
    public RequestContextListenerChainBuilder withListeners(RequestContextListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
        return this;
    }

    @Nonnull
    public RequestContextListenerChainBuilder withoutDefaultListeners() {
        this.withoutDefaultListeners = true;
        return this;
    }

    @Nonnull
    public final RequestContextListenerChainBuilder removeListeners(Collection<Class<? extends RequestContextListener>> listenerClasses) {
        this.listenerClassesToRemove.addAll(listenerClasses);
        return this;
    }

    @Nonnull
    public RequestContextListenerChain build() {
        if (!this.withoutDefaultListeners) {
            this.listeners.addAll(RequestContextListenerChain.getDefaultListeners());
        }
        HashSet<RequestContextListener> listenersToRemove = new HashSet<RequestContextListener>();
        for (RequestContextListener listener : this.listeners) {
            if (!this.listenerClassesToRemove.contains(listener.getClass())) continue;
            listenersToRemove.add(listener);
        }
        this.listeners.removeAll(listenersToRemove);
        this.assertUniquePriorities(this.listeners);
        return new RequestContextListenerChain(this.listeners);
    }

    private void assertUniquePriorities(Iterable<RequestContextListener> listeners) {
        for (RequestContextListener listener1 : listeners) {
            for (RequestContextListener listener2 : listeners) {
                if (listener1 == listener2 || listener1.getPriority() != listener2.getPriority()) continue;
                throw new ShouldNotHappenException("Failed to build " + RequestContextListenerChain.class.getSimpleName() + ": there are two listeners with the same priority " + listener1.getPriority() + ". This is not allowed. Conflicting listeners: " + listener1.getClass().getName() + ", " + listener2.getClass().getName() + ".");
            }
        }
    }

    RequestContextListenerChainBuilder() {
    }
}

