/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChainBuilder;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.slf4j.Logger;

public class RequestContextListenerChain {
    private static final Logger logger = CloudLoggerFactory.getLogger(RequestContextListenerChain.class);
    private final PriorityQueue<RequestContextListener> requestContextListeners;
    static final Comparator<RequestContextListener> naturalOrdering = new NaturalOrderingComparator();
    static final Comparator<RequestContextListener> reverseOrdering = new ReverseOrderingComparator();
    private static final PriorityQueue<RequestContextListener> defaultListeners = new PriorityQueue<RequestContextListener>(10, naturalOrdering);

    public Collection<RequestContextListener> getListeners() {
        return this.requestContextListeners;
    }

    public Collection<RequestContextListener> getListenersReverseOrdering() {
        PriorityQueue<RequestContextListener> reversed = new PriorityQueue<RequestContextListener>(this.requestContextListeners.size() + 1, reverseOrdering);
        reversed.addAll(this.getListeners());
        return reversed;
    }

    public static synchronized void addDefaultListener(RequestContextListener listener) {
        defaultListeners.add(listener);
        if (logger.isInfoEnabled()) {
            logger.info("Added default listener " + listener.getClass().getName() + " with priority " + listener.getPriority() + ".");
        }
    }

    public static synchronized void removeDefaultListener(RequestContextListener listener) {
        defaultListeners.remove(listener);
        if (logger.isInfoEnabled()) {
            logger.info("Removed default listener " + listener.getClass().getName() + " with priority " + listener.getPriority() + ".");
        }
    }

    public static RequestContextListenerChainBuilder builder() {
        return new RequestContextListenerChainBuilder();
    }

    protected RequestContextListenerChain(PriorityQueue<RequestContextListener> requestContextListeners) {
        this.requestContextListeners = requestContextListeners;
    }

    static PriorityQueue<RequestContextListener> getDefaultListeners() {
        return defaultListeners;
    }

    static {
        Collection listeners = FacadeLocator.getFacades(RequestContextListener.class);
        for (RequestContextListener listener : listeners) {
            RequestContextListenerChain.addDefaultListener(listener);
        }
    }

    private static class ReverseOrderingComparator
    implements Comparator<RequestContextListener> {
        private final Comparator<RequestContextListener> naturalOrdering = new NaturalOrderingComparator();

        private ReverseOrderingComparator() {
        }

        @Override
        public int compare(RequestContextListener o1, RequestContextListener o2) {
            return this.naturalOrdering.compare(o1, o2) * -1;
        }
    }

    private static class NaturalOrderingComparator
    implements Comparator<RequestContextListener> {
        private NaturalOrderingComparator() {
        }

        @Override
        public int compare(RequestContextListener o1, RequestContextListener o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    }
}

