/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChain;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestContextCallable<T>
implements Callable<T> {
    @Nonnull
    private final RequestContext requestContext;
    @Nonnull
    private final RequestContextListenerChain requestContextListenerChain;
    @Nonnull
    private final Callable<T> callable;
    @Nullable
    private final RequestContext parentRequestContext;

    public RequestContextCallable(RequestContext requestContext, RequestContextListenerChain requestContextListenerChain, Callable<T> callable) {
        this(requestContext, requestContextListenerChain, callable, null);
    }

    private boolean hasParentRequestContext() {
        return this.parentRequestContext != null;
    }

    private static boolean isContextPresent() {
        return RequestContextAccessor.getCurrentRequestContext().isPresent();
    }

    private void notifyContextInitialized() {
        for (RequestContextListener requestContextListener : this.requestContextListenerChain.getListeners()) {
            requestContextListener.requestContextInitialized(this.requestContext);
        }
    }

    private void notifyContextDestroyed() {
        for (RequestContextListener listener : this.requestContextListenerChain.getListenersReverseOrdering()) {
            listener.requestContextDestroyed(this.requestContext);
        }
    }

    private void setCurrentContext() {
        if (RequestContextCallable.isContextPresent() && !this.hasParentRequestContext()) {
            throw new ShouldNotHappenException("Cannot set current context: " + RequestContext.class.getSimpleName() + " returned by " + RequestContextAccessor.getRequestContextFacade().getClass().getName() + " already initialized. Have you correctly configured a " + RequestContextFactory.class + "?");
        }
        RequestContextAccessor.getRequestContextFacade().setCurrentContext(this.requestContext);
    }

    private void resetCurrentContext() {
        if (!RequestContextCallable.isContextPresent()) {
            throw new ShouldNotHappenException("Cannot remove current context: " + RequestContext.class.getSimpleName() + " returned by " + RequestContextAccessor.getRequestContextFacade().getClass().getName() + " not initialized. Have you correctly configured a " + RequestContextFactory.class + "?");
        }
        if (this.hasParentRequestContext()) {
            RequestContextAccessor.getRequestContextFacade().setCurrentContext(this.parentRequestContext);
        } else {
            RequestContextAccessor.getRequestContextFacade().removeCurrentContext();
        }
    }

    @Override
    public T call() throws Exception {
        this.setCurrentContext();
        try {
            T t;
            this.notifyContextInitialized();
            try {
                t = this.callable.call();
                this.notifyContextDestroyed();
            }
            catch (Throwable throwable) {
                this.notifyContextDestroyed();
                throw throwable;
            }
            return t;
        }
        finally {
            this.resetCurrentContext();
        }
    }

    public RequestContextCallable(@Nonnull RequestContext requestContext, @Nonnull RequestContextListenerChain requestContextListenerChain, @Nonnull Callable<T> callable, @Nullable RequestContext parentRequestContext) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext is marked @NonNull but is null");
        }
        if (requestContextListenerChain == null) {
            throw new NullPointerException("requestContextListenerChain is marked @NonNull but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked @NonNull but is null");
        }
        this.requestContext = requestContext;
        this.requestContextListenerChain = requestContextListenerChain;
        this.callable = callable;
        this.parentRequestContext = parentRequestContext;
    }
}

