/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class DefaultRequestContext
implements RequestContext {
    private static final Logger logger = CloudLoggerFactory.getSanitizedLogger(DefaultRequestContext.class);
    @Nullable
    private final HttpServletRequest request;
    private final long requestThreadId = Thread.currentThread().getId();
    private final ConcurrentMap<String, Property<?>> properties = Maps.newConcurrentMap();

    public DefaultRequestContext(@Nullable HttpServletRequest request) {
        this.request = request;
    }

    @Override
    @Nonnull
    public Optional<HttpServletRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    @Override
    @Nonnull
    public Optional<Property<?>> getProperty(@Nonnull String name) throws RequestContextPropertyException {
        Property property;
        try {
            property = (Property)this.properties.get(name);
            if (logger.isDebugEnabled()) {
                if (property != null) {
                    logger.debug("Retrieved value of property '" + name + "': " + property + ".");
                } else {
                    logger.debug("Property '" + name + "' does not exist, returning empty Optional.");
                }
            }
        }
        catch (ClassCastException | NullPointerException e) {
            throw new RequestContextPropertyException(e);
        }
        return Optional.ofNullable(property);
    }

    @Override
    public void setPropertyIfAbsent(@Nonnull String name, @Nonnull Property<?> value) throws RequestContextPropertyException {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting property '" + name + "' to value: " + value + ".");
        }
        try {
            Property<?> previous = this.properties.putIfAbsent(name, value);
            if (previous != null) {
                throw new RequestContextPropertyException("Failed to set property '" + name + "'. Properties may only be set once.");
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
            throw new RequestContextPropertyException(e);
        }
    }

    @Override
    @Nonnull
    public Optional<Property<?>> removeProperty(@Nonnull String name) throws RequestContextPropertyException {
        try {
            Optional<Property<?>> value = Optional.ofNullable(this.properties.remove(name));
            if (logger.isDebugEnabled()) {
                if (value.isPresent()) {
                    logger.debug("Removed property '" + name + "' with value: " + value.get() + ".");
                } else {
                    logger.debug("Removing property '" + name + "' not required, does not exist.");
                }
            }
            return value;
        }
        catch (ClassCastException | NullPointerException | UnsupportedOperationException e) {
            throw new RequestContextPropertyException(e);
        }
    }

    public String toString() {
        String currentUser;
        String string = currentUser = this.request == null ? null : this.request.getRemoteUser();
        String sessionId = this.request == null ? null : (this.request.getSession(false) == null ? null : this.request.getSession(false).getId());
        return this.getClass().getSimpleName() + "(requestThreadId=" + this.requestThreadId + ", user=" + currentUser + ", sessionId=" + sessionId + ")";
    }

    public ConcurrentMap<String, Property<?>> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRequestContext)) {
            return false;
        }
        DefaultRequestContext other = (DefaultRequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<HttpServletRequest> this$request = this.getRequest();
        Optional<HttpServletRequest> other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        if (this.getRequestThreadId() != other.getRequestThreadId()) {
            return false;
        }
        ConcurrentMap<String, Property<?>> this$properties = this.getProperties();
        ConcurrentMap<String, Property<?>> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultRequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<HttpServletRequest> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        long $requestThreadId = this.getRequestThreadId();
        result = result * 59 + (int)($requestThreadId >>> 32 ^ $requestThreadId);
        ConcurrentMap<String, Property<?>> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Override
    public long getRequestThreadId() {
        return this.requestThreadId;
    }
}

