/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.servlet.DefaultRequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.Executable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextCallable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChain;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChainBuilder;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.NoParentRequestContextException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseRequestContextExecutor<ExecutorT extends BaseRequestContextExecutor<ExecutorT>> {
    @Nonnull
    private RequestContext requestContext = new DefaultRequestContext(null);
    private final RequestContextListenerChainBuilder builder = RequestContextListenerChain.builder();
    @Nullable
    private RequestContext parentRequestContext = null;

    @Nonnull
    public ExecutorT withParentRequestContext() {
        this.parentRequestContext = RequestContextAccessor.getCurrentRequestContext().orElse(null);
        if (this.parentRequestContext == null) {
            throw new NoParentRequestContextException("If you intend to execute one request within another, the outer request context should not be null.");
        }
        return this.getThis();
    }

    @Nonnull
    protected abstract ExecutorT getThis();

    @Nonnull
    public ExecutorT withRequestContext(@Nonnull RequestContext requestContext) {
        this.requestContext = requestContext;
        return this.getThis();
    }

    @Nonnull
    public ExecutorT withoutDefaultListeners() {
        this.builder.withoutDefaultListeners();
        return this.getThis();
    }

    @Nonnull
    public ExecutorT withListeners(RequestContextListener ... listeners) {
        this.builder.withListeners(listeners);
        return this.getThis();
    }

    @Nonnull
    public ExecutorT withoutListener(@Nonnull Class<? extends RequestContextListener> listener) {
        return this.withoutListeners(Collections.singletonList(listener));
    }

    @Nonnull
    public ExecutorT withoutListeners(@Nonnull Collection<Class<? extends RequestContextListener>> listeners) {
        this.builder.removeListeners(listeners);
        return this.getThis();
    }

    @Nullable
    public <T> T execute(@Nonnull Callable<T> callable) throws Exception {
        return new RequestContextCallable<T>(this.requestContext, this.builder.build(), callable, this.parentRequestContext).call();
    }

    public void execute(@Nonnull Executable executable) throws Exception {
        new RequestContextCallable<Object>(this.requestContext, this.builder.build(), () -> {
            executable.execute();
            return null;
        }, this.parentRequestContext).call();
    }
}

