/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet.response;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.monitoring.ExceptionMonitor;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.InvalidParameterException;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.PayloadTooLargeException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.UnexpectedErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.AbstractResponseMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.ConstraintViolationExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.EntityAlreadyExistsExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.EntityNotFoundExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.IllegalArgumentExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.JsonSyntaxExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.NumberFormatExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.PropertyBindingExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.ResponseMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.RuntimeExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.StringParsingExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.TimeoutExceptionMapper;
import com.sap.cloud.sdk.cloudplatform.servlet.response.mapper.UnsupportedOperationExceptionMapper;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResponseBuilder.class);
    public static final int MAX_STACK_TRACE_LEVEL = 20;
    protected final IdentityHashMap<Class<?>, ResponseMapper<?>> responseMappers = Maps.newIdentityHashMap();

    public static ResponseBuilder newBuilder() {
        return new ResponseBuilder().withMapper(new IllegalArgumentExceptionMapper()).withMapper(new JsonSyntaxExceptionMapper()).withMapper(new NumberFormatExceptionMapper()).withMapper(new PropertyBindingExceptionMapper()).withMapper(new RuntimeExceptionMapper()).withMapper(new StringParsingExceptionMapper()).withMapper(new TimeoutExceptionMapper()).withMapper(new UnsupportedOperationExceptionMapper()).withMapper(new ConstraintViolationExceptionMapper()).withMapper(new EntityAlreadyExistsExceptionMapper()).withMapper(new EntityNotFoundExceptionMapper()).logAsWarning(InvalidParameterException.class).logAsWarning(PayloadTooLargeException.class);
    }

    public ResponseBuilder withMapper(ResponseMapper<?> responseMapper) {
        Class<?> throwableClass = responseMapper.getThrowableClass();
        this.responseMappers.put(throwableClass, responseMapper);
        if (log.isInfoEnabled()) {
            log.info("Successfully set " + responseMapper.getClass().getName() + " for " + throwableClass.getName() + ".");
        }
        return this;
    }

    public <ThrowableT extends Throwable> ResponseBuilder withMapper(ResponseMapper<ThrowableT> responseMapper, LogLevel logLevel) {
        Class<ThrowableT> throwableClass = responseMapper.getThrowableClass();
        this.responseMappers.put(throwableClass, new LogLevelDelegateMapper<ThrowableT>(responseMapper, logLevel));
        if (log.isInfoEnabled()) {
            log.info("Successfully set " + responseMapper.getClass().getName() + " for " + throwableClass.getName() + " with log level " + (Object)((Object)logLevel) + ".");
        }
        return this;
    }

    public <ThrowableT extends Throwable> ResponseBuilder logAsLevel(final Class<ThrowableT> throwableClass, final LogLevel logLevel) {
        ResponseMapper<?> responseMapper = this.responseMappers.get(throwableClass);
        if (responseMapper != null) {
            ResponseMapper<?> mapper = responseMapper;
            return this.withMapper(mapper, logLevel);
        }
        this.responseMappers.put(throwableClass, new AbstractResponseMapper<ThrowableT>(){

            @Override
            public Class<ThrowableT> getThrowableClass() {
                return throwableClass;
            }

            @Override
            @Nullable
            public ResponseWithErrorCode toResponse(Throwable throwable) {
                return ((WithErrorResponse)((Object)throwable)).getErrorResponse();
            }

            @Override
            public LogLevel getLogLevel(Throwable throwable) {
                return logLevel;
            }
        });
        if (log.isInfoEnabled()) {
            log.info("Using log level " + (Object)((Object)logLevel) + " for " + throwableClass.getName() + ".");
        }
        return this;
    }

    public <ThrowableT extends Throwable> ResponseBuilder logAsError(Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.INFO);
    }

    public <ThrowableT extends Throwable> ResponseBuilder logAsWarning(Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.WARNING);
    }

    public <ThrowableT extends Throwable> ResponseBuilder logAsInfo(Class<ThrowableT> throwableClass) {
        return this.logAsLevel(throwableClass, LogLevel.INFO);
    }

    public ResponseWithErrorCode build(Throwable throwable) {
        return this.toResponse(throwable, 0);
    }

    protected int getMaxStackTraceLevel() {
        return 20;
    }

    protected ResponseWithErrorCode toResponse(Throwable throwable, int stackTraceLevel) {
        if (stackTraceLevel >= this.getMaxStackTraceLevel()) {
            return this.toResponse(throwable);
        }
        if (throwable.getCause() != null && throwable != throwable.getCause()) {
            this.toResponse(throwable.getCause(), stackTraceLevel + 1);
        }
        return this.toResponse(throwable);
    }

    protected ResponseWithErrorCode toResponse(Throwable throwable) {
        ResponseMapper<?> responseMapper = this.responseMappers.get(throwable.getClass());
        ResponseWithErrorCode response = null;
        LogLevel logLevel = null;
        String logMessage = null;
        if (responseMapper != null) {
            response = responseMapper.toResponse(throwable);
            logLevel = responseMapper.getLogLevel(throwable);
            logMessage = responseMapper.getErrorMessage(throwable);
        }
        if (response == null) {
            response = throwable instanceof WithErrorResponse ? ((WithErrorResponse)((Object)throwable)).getErrorResponse() : new UnexpectedErrorResponse("An unexpected error occurred. For details, please refer to the application log entry with the given referenceId.");
        }
        if (logLevel == null) {
            logLevel = LogLevel.ERROR;
        }
        if (logMessage == null) {
            logMessage = throwable.getMessage();
        }
        logMessage = "Handling throwable with error response (referenceId: " + response.getReferenceId() + ")." + (logMessage == null ? "" : " Message: " + logMessage);
        if (logLevel == LogLevel.WARNING) {
            if (log.isWarnEnabled()) {
                log.warn(logMessage, throwable);
            }
        } else if (logLevel == LogLevel.INFO) {
            if (log.isInfoEnabled()) {
                log.info(logMessage, throwable);
            }
        } else {
            log.error(logMessage, throwable);
            ExceptionMonitor.getInstance().recordException(throwable);
        }
        return response;
    }

    private static class LogLevelDelegateMapper<ThrowableT extends Throwable>
    extends AbstractResponseMapper<ThrowableT> {
        private final ResponseMapper<ThrowableT> delegate;
        private final LogLevel logLevel;

        public LogLevelDelegateMapper(ResponseMapper<ThrowableT> delegate, LogLevel logLevel) {
            this.delegate = delegate;
            this.logLevel = logLevel;
        }

        @Override
        public Class<ThrowableT> getThrowableClass() {
            return this.delegate.getThrowableClass();
        }

        @Override
        @Nullable
        public ResponseWithErrorCode toResponse(Throwable throwable) {
            return this.delegate.toResponse(throwable);
        }

        @Override
        public LogLevel getLogLevel(Throwable throwable) {
            return this.logLevel;
        }

        @Override
        @Nullable
        public String getErrorMessage(Throwable throwable) {
            return this.delegate.getErrorMessage(throwable);
        }
    }
}

