/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.DefaultRequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Executable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextCallable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@WebFilter(filterName="RequestContextServletFilter", urlPatterns={"/*"})
public class RequestContextServletFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(RequestContextServletFilter.class);
    public static final String INIT_PARAMETER_REQUEST_CONTEXT_FACTORY = "factory";
    public static final String INIT_PARAMETER_REQUEST_CONTEXT_LISTENERS = "listeners";
    protected static final PriorityQueue<RequestContextListener> defaultListeners = new PriorityQueue<RequestContextListener>(10, RequestContextListener.naturalOrdering);
    protected RequestContextFactory requestContextFactory;
    protected PriorityQueue<RequestContextListener> requestContextListeners;

    static void assertUniquePriority(PriorityQueue<RequestContextListener> existingListeners, @Nullable RequestContextListener listenerToAdd) {
        for (RequestContextListener existingListener : existingListeners) {
            if (listenerToAdd == null || listenerToAdd.getPriority() != existingListener.getPriority()) continue;
            throw new ShouldNotHappenException("There are two listeners with the same priority. This is not allowed. Existing listener: " + existingListener.getClass().getName() + ", listener to be added: " + listenerToAdd.getClass().getName() + ".");
        }
    }

    public static synchronized void addDefaultListener(RequestContextListener listener) {
        RequestContextServletFilter.assertUniquePriority(defaultListeners, listener);
        defaultListeners.add(listener);
        if (logger.isInfoEnabled()) {
            logger.info("Successfully added default listener: " + listener.getClass().getName() + ".");
        }
    }

    public static synchronized void removeDefaultListener(RequestContextListener listener) {
        defaultListeners.remove(listener);
        if (logger.isInfoEnabled()) {
            logger.info("Successfully removed default listener: " + listener.getClass().getName() + ".");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.loadFactory(filterConfig.getInitParameter(INIT_PARAMETER_REQUEST_CONTEXT_FACTORY));
        this.loadListeners(filterConfig.getInitParameter(INIT_PARAMETER_REQUEST_CONTEXT_LISTENERS));
    }

    protected void loadFactory(String factoryName) {
        block9: {
            if (StringUtils.isNotBlank((CharSequence)factoryName)) {
                try {
                    String trimmedFactoryName = factoryName.trim();
                    Class<?> cls = Class.forName(trimmedFactoryName);
                    Constructor<?> constructor = cls.getConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    if (object instanceof RequestContextFactory) {
                        this.requestContextFactory = (RequestContextFactory)object;
                        if (logger.isInfoEnabled()) {
                            logger.info("Successfully created " + trimmedFactoryName + ".");
                        }
                        break block9;
                    }
                    logger.error("Failed to create " + RequestContextFactory.class.getSimpleName() + ": unsupported type " + trimmedFactoryName + ".");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("Failed to create " + this.getClass().getSimpleName() + ".", (Throwable)e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Filter initialization parameter factory not defined.");
            }
        }
        if (this.requestContextFactory == null) {
            if (logger.isInfoEnabled()) {
                logger.info("No " + RequestContextFactory.class.getSimpleName() + " configured. Falling back to " + DefaultRequestContextFactory.class.getSimpleName() + ".");
            }
            this.requestContextFactory = new DefaultRequestContextFactory();
        }
    }

    protected void loadListeners(String listenerNames) {
        this.requestContextListeners = new PriorityQueue<RequestContextListener>(defaultListeners);
        if (StringUtils.isNotBlank((CharSequence)listenerNames)) {
            String[] splits;
            for (String listenerName : splits = StringUtils.split((String)listenerNames, (char)',')) {
                try {
                    String trimmedListenerName = listenerName.trim();
                    Class<?> cls = Class.forName(trimmedListenerName);
                    Constructor<?> constructor = cls.getConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    if (object instanceof RequestContextListener) {
                        RequestContextServletFilter.assertUniquePriority(this.requestContextListeners, (RequestContextListener)object);
                        this.requestContextListeners.add((RequestContextListener)object);
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Successfully added " + trimmedListenerName + ".");
                        continue;
                    }
                    logger.error("Failed to create " + RequestContextListener.class.getSimpleName() + ": unsupported type " + trimmedListenerName + ".");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("Failed to create " + this.getClass().getSimpleName() + ".", (Throwable)e);
                }
            }
        }
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            RequestContext requestContext = this.requestContextFactory.newRequestContext((HttpServletRequest)request);
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully created " + RequestContext.class.getSimpleName() + ": " + requestContext + ".");
            }
            try {
                new RequestContextCallable<Void>(requestContext, this.requestContextListeners, new Executable(){

                    @Override
                    public void execute() throws IOException, ServletException {
                        filterChain.doFilter(request, response);
                    }
                }).call();
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ShouldNotHappenException((Throwable)e);
            }
        } else {
            logger.error("Failed to initialize " + RequestContext.class.getSimpleName() + ": request not of type " + HttpServletRequest.class.getName() + ".");
        }
    }

    public void destroy() {
    }
}

