/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.servlet.DefaultRequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextCallable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;

public class RequestContextExecutor {
    private RequestContext requestContext = new DefaultRequestContext(null);
    private final PriorityQueue<RequestContextListener> defaultListeners = RequestContextServletFilter.defaultListeners;
    private final PriorityQueue<RequestContextListener> listeners = new PriorityQueue<RequestContextListener>(this.defaultListeners);

    public RequestContextExecutor withRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public RequestContextExecutor withoutDefaultListeners() {
        this.listeners.removeAll(this.defaultListeners);
        return this;
    }

    public RequestContextExecutor withListeners(RequestContextListener ... listeners) {
        List<RequestContextListener> listenerList = Arrays.asList(listeners);
        this.assertUniquePriority(listenerList, this.listeners);
        this.listeners.addAll(listenerList);
        return this;
    }

    private void assertUniquePriority(Iterable<RequestContextListener> listeners1, PriorityQueue<RequestContextListener> listeners2) {
        for (RequestContextListener listener : listeners1) {
            RequestContextServletFilter.assertUniquePriority(listeners2, listener);
        }
    }

    public <T> T execute(Callable<T> callable) throws Exception {
        return new RequestContextCallable<T>(this.requestContext, this.listeners, callable).call();
    }
}

