/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserAccessor {
    @Nullable
    private static UserFacade userFacade = (UserFacade)FacadeLocator.getFacade(UserFacade.class);

    @Nonnull
    static UserFacade facade() throws ShouldNotHappenException {
        if (userFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing user information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare a dependency on com.sap.cloud.s4hana:testutil, add 'private static final MockUtil mockUtil = new MockUtil();' to your test class, and invoke 'mockUtil.mockDefaults();' before running the tests.");
        }
        return userFacade;
    }

    public static void setUserFacade(@Nonnull UserFacade userFacade) {
        UserAccessor.userFacade = userFacade;
    }

    @Nonnull
    public static User getCurrentUser() throws UserNotAuthenticatedException, UserAccessException {
        return UserAccessor.facade().getCurrentUser();
    }

    @Nonnull
    public static Optional<User> getCurrentUserIfAuthenticated() throws UserAccessException {
        return UserAccessor.facade().getCurrentUserIfAuthenticated();
    }

    @Nonnull
    public static Try<User> tryGetCurrentUser() {
        return UserAccessor.facade().tryGetCurrentUser();
    }

    @Nonnull
    public static Optional<User> getUserByName(@Nullable String name) throws UserAccessDeniedException, UserAccessException {
        return UserAccessor.facade().getUserByName(name);
    }

    @Nullable
    public static UserFacade getUserFacade() {
        return userFacade;
    }
}

