/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user.exception;

import com.sap.cloud.sdk.cloudplatform.security.Role;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.servlet.response.AccessDeniedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;
import java.util.Collections;
import javax.annotation.Nullable;

public class UserNotInRoleException
extends RuntimeException
implements WithErrorResponse {
    private static final long serialVersionUID = 3870535945565254939L;
    @Nullable
    private final User user;
    @Nullable
    private final Role role;

    public UserNotInRoleException(@Nullable User user, @Nullable Role role) {
        super("User " + (user != null ? user.getName() + " " : "") + "does not have role" + (role != null ? " " + role.getName() : "") + ".");
        this.user = user;
        this.role = role;
    }

    public UserNotInRoleException(@Nullable User user, @Nullable Role role, String message) {
        super(message);
        this.user = user;
        this.role = role;
    }

    public UserNotInRoleException(@Nullable User user, @Nullable Role role, String message, Throwable cause) {
        super(message, cause);
        this.user = user;
        this.role = role;
    }

    public ResponseWithErrorCode getErrorResponse() {
        return new AccessDeniedResponse(this.user != null ? this.user.getName() : null, this.role != null ? Collections.singleton(this.role.getName()) : null, this.getMessage());
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public Role getRole() {
        return this.role;
    }
}

