/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import javax.annotation.Nullable;

public final class UserAccessor {
    @Nullable
    private static UserFacade userFacade = (UserFacade)FacadeLocator.getFacade(UserFacade.class);

    private static UserFacade facade() throws ShouldNotHappenException {
        UserFacade userFacade = UserAccessor.userFacade;
        if (userFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing user information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SCP Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SCP Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil()\" in your test class and invoke \"mockUtil.mockDefaults()\" before running the tests.");
        }
        return userFacade;
    }

    public static void setUserFacade(UserFacade userFacade) {
        UserAccessor.userFacade = userFacade;
    }

    public static User getCurrentUser() throws UserNotAuthenticatedException {
        return UserAccessor.facade().getCurrentUser();
    }

    public static Optional<User> getUserByName(@Nullable String name) throws UserAccessDeniedException {
        return UserAccessor.facade().getUserByName(name);
    }

    @Nullable
    public static UserFacade getUserFacade() {
        return userFacade;
    }
}

