/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.exception.UnsupportedCloudFeatureException;
import com.sap.cloud.sdk.cloudplatform.jwt.Jwt;
import com.sap.cloud.sdk.cloudplatform.jwt.JwtDecoder;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.ScpCfUser;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ScpCfUserFacade
implements UserFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpCfUserFacade.class);
    private static final String AUTH_HEADER = "Authorization";
    private static final String VARIABLE_ALLOW_MOCKED_AUTH_HEADER = "ALLOW_MOCKED_AUTH_HEADER";
    private static final String JWT_USER_NAME = "user_name";

    public User getCurrentUser() throws UserNotAuthenticatedException {
        HttpServletRequest request = (HttpServletRequest)RequestContextAccessor.getCurrentRequest().orNull();
        if (request == null) {
            throw new UserNotAuthenticatedException("Failed to get current user: request is null.");
        }
        try {
            String env;
            String authorization = request.getHeader(AUTH_HEADER);
            if (!StringUtils.startsWith((CharSequence)authorization, (CharSequence)"Bearer ") && "true".equalsIgnoreCase(env = System.getenv(VARIABLE_ALLOW_MOCKED_AUTH_HEADER))) {
                logger.error("Security is not configured correctly: no Json Web Token found in \"Authorization\" header. Falling back to mocked user with blank user name since environment variable \"ALLOW_MOCKED_AUTH_HEADER\" is set to \"true\". SECURITY WARNING: This must never be the case in productive environments!");
                return new ScpCfUser("", null, null, null);
            }
            String token = StringUtils.removeStart((String)authorization, (String)"Bearer ");
            Jwt jwt = new JwtDecoder().decode(token);
            String userName = jwt.getPayload().get(JWT_USER_NAME).getAsString();
            return new ScpCfUser(userName, null, null, null);
        }
        catch (Exception e) {
            throw new UserNotAuthenticatedException("Failed to get current user from JWT header.", (Throwable)e);
        }
    }

    public Optional<User> getUserByName(String name) {
        throw new UnsupportedCloudFeatureException("Getting users by name not yet supported on SCP CF.");
    }
}

