/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.exception.UnsupportedCloudFeatureException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Scope;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ScpCfUser
implements User {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpCfUser.class);
    private final String name;
    private final Locale locale;
    private final Set<Scope> authorizations = Sets.newHashSet();
    private final Map<String, UserAttribute> attributes = Maps.newHashMap();

    public ScpCfUser(String name, @Nullable Locale locale, @Nullable Collection<Scope> authorizations, @Nullable Map<String, ? extends UserAttribute> attributes) {
        this.name = name;
        this.locale = locale;
        if (authorizations != null) {
            this.authorizations.addAll(authorizations);
        }
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public Optional<Locale> getLocale() {
        return Optional.fromNullable((Object)this.locale);
    }

    public boolean hasAuthorization(Authorization authorization) {
        if (authorization instanceof Scope) {
            return this.authorizations.contains(authorization);
        }
        throw new UnsupportedCloudFeatureException("Authorization with name " + authorization.getName() + " has unsupported type " + authorization.getClass().getSimpleName() + ". Use " + Scope.class.getSimpleName() + " instead.");
    }

    public Set<Authorization> getAuthorizations() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.authorizations);
        return result;
    }

    public Optional<UserAttribute> getAttribute(String name) {
        return Optional.fromNullable((Object)this.attributes.get(name));
    }

    public String getName() {
        return this.name;
    }

    public Map<String, UserAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScpCfUser)) {
            return false;
        }
        ScpCfUser other = (ScpCfUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<Locale> this$locale = this.getLocale();
        Optional<Locale> other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        Set<Authorization> this$authorizations = this.getAuthorizations();
        Set<Authorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        Map<String, UserAttribute> this$attributes = this.getAttributes();
        Map<String, UserAttribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScpCfUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<Locale> $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        Set<Authorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        Map<String, UserAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "ScpCfUser(name=" + this.getName() + ", locale=" + this.getLocale() + ", authorizations=" + this.getAuthorizations() + ", attributes=" + this.getAttributes() + ")";
    }
}

