/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpEntityUtil {
    private static final Logger logger = CloudLoggerFactory.getSanitizedLogger(HttpEntityUtil.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getResponseBody(@Nonnull HttpResponse response) throws IOException, ParseException {
        String string;
        Object responseEntity = null;
        try {
            Object[] encodingHeaders = response.getHeaders("Content-Encoding");
            if (encodingHeaders.length > 1) {
                logger.warn("Multiple headers for Content-Encoding: " + Arrays.toString(encodingHeaders) + ".");
            }
            responseEntity = encodingHeaders.length >= 1 && encodingHeaders[0].getValue().equalsIgnoreCase("gzip") ? new GzipDecompressingEntity(response.getEntity()) : response.getEntity();
            string = EntityUtils.toString((HttpEntity)responseEntity, (String)DEFAULT_CHARSET.toString());
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume(responseEntity);
            }
            catch (IOException e) {
                logger.warn("Failed to consume HTTP response entity.", (Throwable)e);
            }
            throw throwable;
        }
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
        }
        catch (IOException e) {
            logger.warn("Failed to consume HTTP response entity.", (Throwable)e);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static String getResponsePayload(HttpResponse response) throws IOException, ParseException {
        return HttpEntityUtil.getResponseBody(response);
    }
}

