/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@Beta
public class FallbackDestinationFacade
extends AbstractDestinationFacade {
    @Nonnull
    private final DestinationFacade primaryFacade;
    @Nonnull
    private final DestinationFacade fallbackFacade;

    public FallbackDestinationFacade(@Nonnull DestinationFacade primaryFacade, @Nonnull DestinationFacade fallbackFacade) {
        this.primaryFacade = primaryFacade;
        this.fallbackFacade = fallbackFacade;
    }

    @Override
    @Nonnull
    public Class<? extends GenericDestination> getGenericDestinationClass() {
        return GenericDestination.class;
    }

    @Override
    @Nonnull
    public Class<? extends Destination> getDestinationClass() {
        return Destination.class;
    }

    @Override
    @Nonnull
    public Class<? extends RfcDestination> getRfcDestinationClass() {
        return RfcDestination.class;
    }

    @Override
    @Nonnull
    public Map<String, GenericDestination> getGenericDestinationsByName() throws DestinationAccessException {
        Map<String, GenericDestination> primaryMap = this.primaryFacade.getGenericDestinationsByName();
        Map<String, GenericDestination> fallbackMap = this.fallbackFacade.getGenericDestinationsByName();
        HashMap<String, GenericDestination> combinedMap = new HashMap<String, GenericDestination>(fallbackMap);
        combinedMap.putAll(primaryMap);
        return combinedMap;
    }
}

