/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;

public abstract class DestinationDeclarator
implements ServletContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(DestinationDeclarator.class);
    private final Set<String> destinationNames = Sets.newHashSet();

    public DestinationDeclarator(@Nonnull String destinationName, String ... destinationNames) {
        this.destinationNames.add(destinationName);
        this.destinationNames.addAll(Arrays.asList(destinationNames));
    }

    public DestinationDeclarator(@Nonnull Collection<String> destinationNames) {
        this.destinationNames.addAll(destinationNames);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        DestinationAccessor.declareDestinations(this.destinationNames);
        if (logger.isInfoEnabled()) {
            logger.info("Successfully declared destinations: " + this.destinationNames + ".");
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public Set<String> getDestinationNames() {
        return this.destinationNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DestinationDeclarator)) {
            return false;
        }
        DestinationDeclarator other = (DestinationDeclarator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$destinationNames = this.getDestinationNames();
        Set<String> other$destinationNames = other.getDestinationNames();
        return !(this$destinationNames == null ? other$destinationNames != null : !((Object)this$destinationNames).equals(other$destinationNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DestinationDeclarator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $destinationNames = this.getDestinationNames();
        result = result * 59 + ($destinationNames == null ? 43 : ((Object)$destinationNames).hashCode());
        return result;
    }

    public String toString() {
        return "DestinationDeclarator(destinationNames=" + this.getDestinationNames() + ")";
    }
}

