/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.UriBuilder;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class UriPathMerger {
    private static final Logger logger = CloudLoggerFactory.getLogger(UriPathMerger.class);

    public URI merge(URI destinationUri, URI requestUri) {
        try {
            if (requestUri != null) {
                String requestPath = requestUri.getRawPath();
                if (logger.isDebugEnabled()) {
                    logger.debug("Merging request path: " + requestPath);
                }
                String destinationUriPath = destinationUri.getRawPath();
                this.assertRequestUriMatchesDestinationUri(destinationUri, requestUri);
                if (logger.isDebugEnabled()) {
                    logger.debug("Successfully merged request path: " + requestPath);
                }
                if (!requestUri.isAbsolute()) {
                    requestPath = this.mergeUriPaths(destinationUriPath, requestPath);
                }
                return new UriBuilder().build(destinationUri.getScheme(), requestUri.getRawUserInfo(), destinationUri.getHost(), destinationUri.getPort(), requestPath, requestUri.getRawQuery(), requestUri.getRawFragment());
            }
            String requestPath = destinationUri.getRawPath();
            requestPath = requestPath.replaceAll("^/", "");
            requestPath = "/" + requestPath;
            return new UriBuilder().build(destinationUri.getScheme(), destinationUri.getRawUserInfo(), destinationUri.getHost(), destinationUri.getPort(), requestPath, destinationUri.getRawQuery(), destinationUri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new ShouldNotHappenException("Failed to merge request URI.", (Throwable)e);
        }
    }

    private void assertRequestUriMatchesDestinationUri(URI destinationUri, URI requestUri) {
        if (requestUri.getHost() != null) {
            boolean isPortEqual;
            boolean isSchemeEqual = destinationUri.getScheme().equalsIgnoreCase(requestUri.getScheme());
            boolean isHostEqual = destinationUri.getHost().equalsIgnoreCase(requestUri.getHost());
            boolean bl = isPortEqual = destinationUri.getPort() == destinationUri.getPort();
            if (!(isSchemeEqual && isHostEqual && isPortEqual)) {
                throw new ShouldNotHappenException("URIs defined in destination \"" + destinationUri + "\" and supplied by application code \"" + requestUri + "\" differ.");
            }
        }
    }

    private String mergeUriPaths(String firstPath, String secondPath) {
        if (firstPath == null || secondPath == null) {
            throw new ShouldNotHappenException("Cannot merge URI paths that are null.");
        }
        String first = StringUtils.removeStart((String)StringUtils.trim((String)firstPath), (String)"/");
        String second = StringUtils.removeStart((String)StringUtils.trim((String)secondPath), (String)"/");
        String result = second.isEmpty() ? first : (second.startsWith(first) ? second : StringUtils.appendIfMissing((String)first, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + second);
        return StringUtils.prependIfMissing((String)result, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

