/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.s4hana.quality.QualityListenerException;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.UriPathMerger;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.ServiceLoader;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

class HttpClientWrapper
implements HttpClient {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpClientWrapper.class);
    private static final List<HttpClientListener> listeners = ImmutableList.copyOf(ServiceLoader.load(HttpClientListener.class));
    private final HttpClient httpClient;
    private final Destination destination;

    HttpClientWrapper(HttpClient httpClient, Destination destination) {
        this.httpClient = httpClient;
        this.destination = destination;
    }

    private HttpUriRequest wrapRequest(HttpUriRequest request) {
        URI requestUri = new UriPathMerger().merge(this.destination.getUri(), request.getURI());
        try {
            Object requestWrapper = request instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request) : new RequestWrapper((HttpRequest)request);
            requestWrapper.setURI(requestUri);
            for (Header header : this.destination.getHeaders(requestUri)) {
                requestWrapper.addHeader((org.apache.http.Header)new ApacheHttpHeader(header));
            }
            return requestWrapper;
        }
        catch (ProtocolException e) {
            throw new ShouldNotHappenException((Throwable)e);
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        this.notifyListeners(httpUriRequest.getURI());
        return this.httpClient.execute(httpUriRequest);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        this.notifyListeners(httpUriRequest.getURI());
        return this.httpClient.execute(httpUriRequest, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        this.notifyListeners(target.toURI(), request.getRequestLine().getUri());
        return this.httpClient.execute(target, request);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        this.notifyListeners(httpUriRequest.getURI());
        return (T)this.httpClient.execute(httpUriRequest, responseHandler);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        this.notifyListeners(target.toURI(), request.getRequestLine().getUri());
        return this.httpClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        this.notifyListeners(request.getURI());
        return (T)this.httpClient.execute(this.wrapRequest(request), responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        this.notifyListeners(target.toURI(), request.getRequestLine().getUri());
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        this.notifyListeners(target.toURI(), request.getRequestLine().getUri());
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    private void notifyListeners(URI uri) {
        String portString = uri.getPort() == -1 ? "" : String.valueOf(uri.getPort());
        String scheme = StringUtils.defaultString((String)uri.getScheme());
        if (!StringUtils.isBlank((CharSequence)scheme)) {
            scheme = scheme + "://";
        }
        String reducedUri = scheme + StringUtils.defaultString((String)uri.getHost()) + portString + StringUtils.defaultString((String)uri.getPath());
        for (HttpClientListener listener : listeners) {
            try {
                listener.onRequest(reducedUri);
            }
            catch (QualityListenerException e) {
                logger.error("Failure while invoking query listener of type " + listener.getClass().getName() + ".", (Throwable)e);
            }
        }
    }

    private void notifyListeners(String targetUriString, String requestUriString) {
        try {
            this.notifyListeners(URI.create(targetUriString + requestUriString));
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to construct URI from '" + targetUriString + "' and '" + requestUriString + "'.", (Throwable)e);
        }
    }

    private static class ApacheHttpHeader
    implements org.apache.http.Header {
        @NonNull
        private final Header header;

        public String getName() {
            return this.header.getName();
        }

        public String getValue() {
            return this.header.getValue();
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }

        @ConstructorProperties(value={"header"})
        public ApacheHttpHeader(@NonNull Header header) {
            if (header == null) {
                throw new NullPointerException("header");
            }
            this.header = header;
        }
    }
}

