/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientWrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;

class HttpClientBuilder {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpClientBuilder.class);
    private static final String JDK_TRUSTSTORE_PATH = System.getProperty("java.home") + "/lib/security/cacerts";
    private static final int DEFAULT_TIMEOUT_MINUTES = 2;
    private static final int MAX_TOTAL_CONNECTIONS = 200;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 100;
    @NonNull
    private final Destination destination;
    private DefaultHttpClient httpClient;

    HttpClientBuilder(Destination destination) throws HttpClientInstantiationException {
        this.destination = destination;
        DestinationType destinationType = this.destination.getDestinationType();
        if (!DestinationType.HTTP.equals(destinationType)) {
            throw new HttpClientInstantiationException(HttpClient.class.getSimpleName() + " creation is only supported for " + DestinationType.class.getSimpleName() + " " + DestinationType.HTTP + ". Actual type: " + destinationType + ".");
        }
    }

    HttpClient build() throws DestinationAccessException, HttpClientInstantiationException {
        this.httpClient = new DefaultHttpClient(this.getConnectionManager());
        this.setTimeout();
        this.setProxy();
        return new HttpClientWrapper((HttpClient)this.httpClient, this.destination);
    }

    private ClientConnectionManager getConnectionManager() throws HttpClientInstantiationException {
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        if ("https".equalsIgnoreCase(this.destination.getUri().getScheme())) {
            try {
                TrustManager[] trustManagers = this.getTrustManagers();
                KeyManager[] keyManagers = this.getKeyManagers();
                String tlsVersion = this.destination.getPropertiesByName().get("TLSVersion");
                SSLContext sslContext = SSLContext.getInstance(tlsVersion != null ? tlsVersion : "TLSv1.2");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, (X509HostnameVerifier)new StrictHostnameVerifier());
                connectionManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HttpClientInstantiationException(e);
            }
        }
        return connectionManager;
    }

    private void setTimeout() {
        int milliseconds = (int)TimeUnit.MINUTES.toMillis(2L);
        try {
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)milliseconds);
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)milliseconds);
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to set timeout on " + HttpClient.class.getSimpleName() + ". This is expected within unit tests.");
        }
    }

    private void setProxy() {
        ProxyType proxyType = this.destination.getProxyType();
        ProxyConfiguration proxyConfiguration = (ProxyConfiguration)this.destination.getProxyConfiguration().orNull();
        if (proxyConfiguration != null) {
            try {
                URI uri = proxyConfiguration.getUri();
                if (uri == null) {
                    throw new IllegalArgumentException("Empty URI in ProxyConfiguration.");
                }
                String host = uri.getHost();
                if (host == null) {
                    throw new IllegalArgumentException("Empty host in ProxyConfiguration.");
                }
                int port = uri.getPort();
                com.sap.cloud.sdk.cloudplatform.security.Credentials credentials = (com.sap.cloud.sdk.cloudplatform.security.Credentials)proxyConfiguration.getCredentials().orNull();
                if (credentials instanceof BasicCredentials) {
                    BasicCredentials basicCredentials = (BasicCredentials)credentials;
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(basicCredentials.getUsername(), basicCredentials.getPassword()));
                }
                this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port, uri.getScheme()));
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to set proxy. This behavior may be expected in tests or some local runtimes such as SCP Neo.", (Throwable)e);
            }
        } else if (ProxyType.ON_PREMISE == proxyType && logger.isWarnEnabled()) {
            logger.warn("No proxy configuration available for on-premise connectivity.");
        }
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException {
        ArrayList trustManagers = Lists.newArrayList();
        if (this.destination.isTrustingAllCertificates()) {
            trustManagers.add(new TrustAllTrustManager());
        } else {
            TrustManager destinationTrustManager;
            TrustManager defaultTrustManager = this.createTrustManager(this.getJdkTrustStore());
            if (defaultTrustManager != null) {
                trustManagers.add(defaultTrustManager);
            }
            if ((destinationTrustManager = this.createTrustManager((KeyStore)this.destination.getTrustStore().orNull())) != null) {
                trustManagers.add(destinationTrustManager);
            }
        }
        return trustManagers.toArray(new TrustManager[trustManagers.size()]);
    }

    private TrustManager createTrustManager(@Nullable KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        if (keyStore == null) {
            return null;
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers != null && trustManagers.length > 0) {
            return trustManagers[0];
        }
        return null;
    }

    private KeyStore getJdkTrustStore() throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream is = new FileInputStream(JDK_TRUSTSTORE_PATH);){
            keyStore.load(is, null);
        }
        return keyStore;
    }

    private KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = (KeyStore)this.destination.getKeyStore().orNull();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String keyStorePassword = (String)this.destination.getKeyStorePassword().or((Object)"");
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    @NonNull
    public Destination getDestination() {
        return this.destination;
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientBuilder)) {
            return false;
        }
        HttpClientBuilder other = (HttpClientBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Destination this$destination = this.getDestination();
        Destination other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        DefaultHttpClient this$httpClient = this.getHttpClient();
        DefaultHttpClient other$httpClient = other.getHttpClient();
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Destination $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        DefaultHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientBuilder(destination=" + this.getDestination() + ", httpClient=" + this.getHttpClient() + ")";
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

