/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationsRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.HttpClient;

public final class HttpClientAccessor {
    private static HttpClientFactory httpClientProvider = new DefaultHttpClientFactory();

    public static HttpClient getHttpClient(String destinationName) throws DestinationNotFoundException, DestinationAccessException, HttpClientInstantiationException {
        return HttpClientAccessor.getHttpClient(DestinationAccessor.getDestination(destinationName));
    }

    public static HttpClient getHttpClient(final Destination destination) throws DestinationAccessException, HttpClientInstantiationException {
        Optional currentRequestContext = RequestContextAccessor.getCurrentRequestContext();
        if (currentRequestContext.isPresent()) {
            Optional property;
            String propertyName = DestinationsRequestContextListener.PROPERTY_HTTP_CLIENTS;
            try {
                property = ((RequestContext)currentRequestContext.get()).getProperty(propertyName);
            }
            catch (RequestContextPropertyException e) {
                throw new ShouldNotHappenException("Failed to get the " + HttpClient.class.getSimpleName() + " cache from " + RequestContext.class.getSimpleName() + " property \"" + propertyName + "\".", (Throwable)e);
            }
            Cache cache = (Cache)property.orNull();
            if (cache == null) {
                throw new ShouldNotHappenException("Failed to get the " + HttpClient.class.getSimpleName() + " cache from " + RequestContext.class.getSimpleName() + " property \"" + propertyName + "\". Have you correctly registered a " + DestinationsRequestContextListener.class.getSimpleName() + " in the " + RequestContextServletFilter.class.getSimpleName() + "? A missing cache can also be caused by a preceding issue during the initialization of the " + DestinationsRequestContextListener.class.getSimpleName() + ". To analyze the root cause, increase the log level of the " + DestinationsRequestContextListener.class.getSimpleName() + " and the current " + DestinationFacade.class.getSimpleName() + " implementation.");
            }
            try {
                return (HttpClient)cache.get((Object)destination.getName(), (Callable)new Callable<HttpClient>(){

                    @Override
                    public HttpClient call() throws HttpClientInstantiationException {
                        return httpClientProvider.createHttpClient(destination);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new HttpClientInstantiationException(e);
            }
        }
        return httpClientProvider.createHttpClient(destination);
    }

    public static HttpClientFactory getHttpClientProvider() {
        return httpClientProvider;
    }

    public static void setHttpClientProvider(HttpClientFactory httpClientProvider) {
        HttpClientAccessor.httpClientProvider = httpClientProvider;
    }
}

