/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditedDataObject {
    private String type;
    private final Map<String, String> identifiers;

    public AuditedDataObject(@Nonnull String type) {
        this(type, UUID.randomUUID().toString());
    }

    public AuditedDataObject(@Nonnull String type, @Nonnull String id) {
        this.type = type;
        this.identifiers = Maps.newHashMap();
        this.identifiers.put(AuditedDataObject.class.getSimpleName(), id);
    }

    public void setIdentifier(@Nonnull String propertyName, String value) {
        this.identifiers.put(propertyName, value);
    }

    @Nullable
    public String getIdentifier(@Nonnull String propertyName) {
        return this.identifiers.get(propertyName);
    }

    @Nonnull
    public Map<String, String> getAllIdentifiers() {
        return this.identifiers;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

