/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogFacade;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AuditLogger {
    @Nullable
    private static AuditLogFacade auditLogFacade = (AuditLogFacade)FacadeLocator.getFacade(AuditLogFacade.class);

    private static AuditLogFacade facade() throws ShouldNotHappenException {
        if (auditLogFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing the audit log. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare a dependency on com.sap.cloud.s4hana:testutil, add 'private static final MockUtil mockUtil = new MockUtil();' to your test class, and invoke 'mockUtil.mockDefaults();' before running the tests.");
        }
        return auditLogFacade;
    }

    public static void setAuditLogFacade(@Nullable AuditLogFacade auditLogFacade) {
        AuditLogger.auditLogFacade = auditLogFacade;
    }

    @Nonnull
    public static AuditLog getAuditLog() {
        return AuditLogger.facade().getAuditLog();
    }

    public static void logSecurityEventBeginning(AccessRequester initiator, String message) {
        AuditLogger.getAuditLog().logSecurityEventBeginning(initiator, message);
    }

    public static void logSecurityEventBeginning(String message) {
        AuditLogger.logSecurityEventBeginning(AccessRequester.ofCurrentRequest(), message);
    }

    public static void logSecurityEvent(AccessRequester initiator, String message, @Nullable Throwable throwable) {
        AuditLogger.getAuditLog().logSecurityEvent(initiator, message, throwable);
    }

    public static void logSecurityEvent(String message, @Nullable Throwable throwable) {
        AuditLogger.logSecurityEvent(AccessRequester.ofCurrentRequest(), message, throwable);
    }

    @Deprecated
    public static void logConfigChangeBeginning(AccessRequester initiator, AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.getAuditLog().logConfigChangeBeginning(initiator, object, attributesAffected);
    }

    public static void logConfigChangeBeginning(AccessRequester initiator, AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logConfigChangeBeginning(initiator, object, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logConfigChangeBeginning(AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.logConfigChangeBeginning(AccessRequester.ofCurrentRequest(), object, attributesAffected);
    }

    public static void logConfigChangeBeginning(AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logConfigChangeBeginning(AccessRequester.ofCurrentRequest(), object, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logConfigChange(AccessRequester initiator, AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logConfigChange(initiator, object, attributesAffected, error);
    }

    public static void logConfigChange(AccessRequester initiator, AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logConfigChange(initiator, object, error, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logConfigChange(AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.logConfigChange(AccessRequester.ofCurrentRequest(), object, attributesAffected, error);
    }

    public static void logConfigChange(AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logConfigChange(AccessRequester.ofCurrentRequest(), object, error, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataReadAttempt(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.getAuditLog().logDataReadAttempt(initiator, object, subject, attributesAffected);
    }

    public static void logDataReadAttempt(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataReadAttempt(initiator, object, subject, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataReadAttempt(AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.logDataReadAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributesAffected);
    }

    public static void logDataReadAttempt(AuditedDataObject object, AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataReadAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataRead(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logDataRead(initiator, object, subject, attributesAffected, error);
    }

    public static void logDataRead(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataRead(initiator, object, subject, error, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataRead(AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.logDataRead(AccessRequester.ofCurrentRequest(), object, subject, attributesAffected, error);
    }

    public static void logDataRead(AuditedDataObject object, AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataRead(AccessRequester.ofCurrentRequest(), object, subject, error, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataWriteAttempt(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.getAuditLog().logDataWriteAttempt(initiator, object, subject, attributesAffected);
    }

    public static void logDataWriteAttempt(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataWriteAttempt(initiator, object, subject, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataWriteAttempt(AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        AuditLogger.logDataWriteAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributesAffected);
    }

    public static void logDataWriteAttempt(AuditedDataObject object, AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataWriteAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataWrite(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logDataWrite(initiator, object, subject, attributesAffected, error);
    }

    public static void logDataWrite(AccessRequester initiator, AuditedDataObject object, AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataWrite(initiator, object, subject, error, attributeAffected, attributesAffected);
    }

    @Deprecated
    public static void logDataWrite(AuditedDataObject object, AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        AuditLogger.logDataWrite(AccessRequester.ofCurrentRequest(), object, subject, attributesAffected, error);
    }

    public static void logDataWrite(AuditedDataObject object, AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataWrite(AccessRequester.ofCurrentRequest(), object, subject, error, attributeAffected, attributesAffected);
    }

    @Nullable
    public static AuditLogFacade getAuditLogFacade() {
        return auditLogFacade;
    }
}

