/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class AccessRequester {
    private static final Logger logger = CloudLoggerFactory.getLogger(AccessRequester.class);
    public static final AccessRequester UNKNOWN = new AccessRequester(null, null, null, null);
    public static final String UNAUTHENTICATED_USER = "noauth";
    @Nullable
    private final String userId;
    @Nullable
    public final String tenantId;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final String channel;

    @Nonnull
    public Optional<String> getUserId() {
        return Optional.ofNullable(this.userId);
    }

    @Nonnull
    public Optional<String> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    @Nonnull
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    @Nonnull
    public Optional<String> getChannel() {
        return Optional.ofNullable(this.channel);
    }

    public AccessRequester(@Nonnull HttpServletRequest request) {
        this.userId = this.fetchUserId();
        this.tenantId = null;
        this.ipAddress = request.getRemoteAddr();
        this.channel = request.getScheme();
    }

    public AccessRequester(@Nonnull HttpServletRequest request, @Nonnull Tenant tenant) {
        this.userId = this.fetchUserId();
        this.tenantId = tenant.getTenantId();
        this.ipAddress = request.getRemoteAddr();
        this.channel = request.getScheme();
    }

    @Nullable
    public static AccessRequester of(@Nullable HttpServletRequest request) {
        if (request == null) {
            return UNKNOWN;
        }
        return new AccessRequester(request);
    }

    @Nullable
    public static AccessRequester of(@Nullable HttpServletRequest request, @Nullable Tenant tenant) {
        if (request != null) {
            if (tenant != null) {
                return new AccessRequester(request, tenant);
            }
            return new AccessRequester(request);
        }
        return UNKNOWN;
    }

    @Nullable
    public static AccessRequester ofCurrentRequest() {
        HttpServletRequest request = RequestContextAccessor.getCurrentRequest().orElse(null);
        try {
            Tenant currentTenant = TenantAccessor.getCurrentTenant();
            return AccessRequester.of(request, currentTenant);
        }
        catch (TenantAccessException | TenantNotAvailableException e) {
            return AccessRequester.of(request);
        }
    }

    @Nonnull
    private String fetchUserId() {
        try {
            Optional currentUser;
            if (UserAccessor.getUserFacade() != null && (currentUser = UserAccessor.getCurrentUserIfAuthenticated()).isPresent()) {
                return ((User)currentUser.get()).getName();
            }
        }
        catch (UserAccessException e) {
            logger.warn("There was a problem getting the current user. ", (Throwable)e);
        }
        return UNAUTHENTICATED_USER;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessRequester)) {
            return false;
        }
        AccessRequester other = (AccessRequester)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$userId = this.getUserId();
        Optional<String> other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Optional<String> this$tenantId = this.getTenantId();
        Optional<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        Optional<String> this$ipAddress = this.getIpAddress();
        Optional<String> other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !((Object)this$ipAddress).equals(other$ipAddress)) {
            return false;
        }
        Optional<String> this$channel = this.getChannel();
        Optional<String> other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessRequester;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Optional<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        Optional<String> $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : ((Object)$ipAddress).hashCode());
        Optional<String> $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        return result;
    }

    public String toString() {
        return "AccessRequester(userId=" + this.getUserId() + ", tenantId=" + this.getTenantId() + ", ipAddress=" + this.getIpAddress() + ", channel=" + this.getChannel() + ")";
    }

    public AccessRequester(@Nullable String userId, @Nullable String tenantId, @Nullable String ipAddress, @Nullable String channel) {
        this.userId = userId;
        this.tenantId = tenantId;
        this.ipAddress = ipAddress;
        this.channel = channel;
    }
}

