/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogFacade;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import javax.annotation.Nullable;

public final class AuditLogger {
    @Nullable
    private static AuditLogFacade auditLogFacade = (AuditLogFacade)FacadeLocator.getFacade(AuditLogFacade.class);

    private static AuditLogFacade facade() throws ShouldNotHappenException {
        AuditLogFacade auditLogFacade = AuditLogger.auditLogFacade;
        if (auditLogFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing the audit log. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SCP Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SCP Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil()\" in your test class and invoke \"mockUtil.mockDefaults()\" before running the tests.");
        }
        return auditLogFacade;
    }

    public static void setAuditLogFacade(AuditLogFacade auditLogFacade) {
        AuditLogger.auditLogFacade = auditLogFacade;
    }

    public static AuditLog getAuditLog() {
        return AuditLogger.facade().getAuditLog();
    }

    public static void logSecurityEventBeginning(AccessRequester initiator, String message) {
        AuditLogger.getAuditLog().logSecurityEventBeginning(initiator, message);
    }

    public static void logSecurityEventBeginning(String message) {
        AuditLogger.logSecurityEventBeginning(AccessRequester.ofCurrentRequest(), message);
    }

    public static void logSecurityEvent(AccessRequester initiator, String message, @Nullable Throwable throwable) {
        AuditLogger.getAuditLog().logSecurityEvent(initiator, message, throwable);
    }

    public static void logSecurityEvent(String message, @Nullable Throwable throwable) {
        AuditLogger.logSecurityEvent(AccessRequester.ofCurrentRequest(), message, throwable);
    }

    public static void logConfigChangeBeginning(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.getAuditLog().logConfigChangeBeginning(initiator, objectId, objectName, attributesAffected, message);
    }

    public static void logConfigChangeBeginning(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.logConfigChangeBeginning(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message);
    }

    public static void logConfigChange(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logConfigChange(initiator, objectId, objectName, attributesAffected, message, error);
    }

    public static void logConfigChange(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.logConfigChange(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message, error);
    }

    public static void logDataReadAttempt(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.getAuditLog().logDataReadAttempt(initiator, objectId, objectName, attributesAffected, message);
    }

    public static void logDataReadAttempt(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.logDataReadAttempt(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message);
    }

    public static void logDataRead(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logDataRead(initiator, objectId, objectName, attributesAffected, message, error);
    }

    public static void logDataRead(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.logDataRead(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message, error);
    }

    public static void logDataWriteAttempt(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.getAuditLog().logDataWriteAttempt(initiator, objectId, objectName, attributesAffected, message);
    }

    public static void logDataWriteAttempt(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        AuditLogger.logDataWriteAttempt(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message);
    }

    public static void logDataWrite(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.getAuditLog().logDataWrite(initiator, objectId, objectName, attributesAffected, message, error);
    }

    public static void logDataWrite(String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        AuditLogger.logDataWrite(AccessRequester.ofCurrentRequest(), objectId, objectName, attributesAffected, message, error);
    }

    @Nullable
    public static AuditLogFacade getAuditLogFacade() {
        return auditLogFacade;
    }
}

