/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;

public final class AccessRequester {
    public static final AccessRequester UNKNOWN = new AccessRequester(null, null, null);
    public static final String UNAUTHENTICATED_USER = "noauth";
    @Nullable
    private final String userId;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final String channel;

    public Optional<String> getUserId() {
        return Optional.fromNullable((Object)this.userId);
    }

    public Optional<String> getIpAddress() {
        return Optional.fromNullable((Object)this.ipAddress);
    }

    public Optional<String> getChannel() {
        return Optional.fromNullable((Object)this.channel);
    }

    public AccessRequester(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        this.userId = Strings.isNullOrEmpty((String)request.getRemoteUser()) ? UNAUTHENTICATED_USER : request.getRemoteUser();
        this.ipAddress = request.getRemoteAddr();
        this.channel = request.getScheme();
    }

    @Nullable
    @Contract(value="null -> null")
    public static AccessRequester of(@Nullable HttpServletRequest request) throws IllegalArgumentException {
        if (request == null) {
            return UNKNOWN;
        }
        return new AccessRequester(request);
    }

    @Nullable
    public static AccessRequester ofCurrentRequest() throws IllegalArgumentException {
        return AccessRequester.of((HttpServletRequest)RequestContextAccessor.getCurrentRequest().orNull());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessRequester)) {
            return false;
        }
        AccessRequester other = (AccessRequester)o;
        Optional<String> this$userId = this.getUserId();
        Optional<String> other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Optional<String> this$ipAddress = this.getIpAddress();
        Optional<String> other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        Optional<String> this$channel = this.getChannel();
        Optional<String> other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Optional<String> $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        Optional<String> $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    public String toString() {
        return "AccessRequester(userId=" + this.getUserId() + ", ipAddress=" + this.getIpAddress() + ", channel=" + this.getChannel() + ")";
    }

    @ConstructorProperties(value={"userId", "ipAddress", "channel"})
    public AccessRequester(@Nullable String userId, @Nullable String ipAddress, @Nullable String channel) {
        this.userId = userId;
        this.ipAddress = ipAddress;
        this.channel = channel;
    }
}

