/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum SQLStatementType {
    CEKCreation(1),
    CKPCreation(2),
    EmptyCEKPopulating(3),
    AccessCEKGranting(4),
    CEKChanging(5),
    ColumnEncryption(6),
    ColumnUnEncryption(7),
    CKPDrop(8),
    CEKDrop(9),
    CEKKeyCopyDrop(10),
    CKPNewVersionAdd(11),
    CKPNewVersionAddWithKeyValue(12),
    AccessCEKGrantingMultiple(13),
    CEKNewVersionAdd(14),
    CEKRotation(15),
    CEKChangingMultiple(16),
    CKPDropMultiple(17),
    CEKDropMultiple(18),
    Unknown(-1);

    private static final SQLStatementType[] VALUES;

    public static SQLStatementType decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return SQLStatementType.decode(value).name() + '(' + value + ')';
    }

    private SQLStatementType(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public boolean isForClientSideEncryption() {
        return true;
    }

    static {
        VALUES = SQLStatementType.values();
    }
}

