/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SystemInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadSafe
final class Topologies {
    @GuardedBy(value="Topologies.class")
    private static final Map<PreferredAddress, TopologyInfo> TOPOLOGIES = new HashMap<PreferredAddress, TopologyInfo>();
    @GuardedBy(value="Topologies.class")
    private static final Map<PublicAddress, PreferredAddress> ALTERNATES = new HashMap<PublicAddress, PreferredAddress>();
    @GuardedBy(value="Topologies.class")
    private static final Set<Address> UNREACHABLES = new HashSet<Address>();
    @GuardedBy(value="Topologies.class")
    private static int _setTopologyCount;
    @GuardedBy(value="Topologies.class")
    private static int _setAlternateCount;
    @GuardedBy(value="Topologies.class")
    private static int _setUnreachableCount;

    private Topologies() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static synchronized TopologyInfo getTopologyInfo(PreferredAddress preferredAddress) {
        return TOPOLOGIES.get(preferredAddress);
    }

    static synchronized void setTopologyInfo(PreferredAddress preferredAddress, SystemInfo systemInfo, SiteType siteType, SMVRRole smvrRole) {
        TopologyInfo currentTopologyInfo = TOPOLOGIES.get(preferredAddress);
        int currentAddressCounter = currentTopologyInfo != null ? currentTopologyInfo._nextAddressCounter.get() : 0;
        TopologyInfo newTopologyInfo = new TopologyInfo(systemInfo, siteType, smvrRole, currentAddressCounter);
        TOPOLOGIES.put(preferredAddress, newTopologyInfo);
        ++_setTopologyCount;
    }

    static synchronized PreferredAddress getPreferredAddress(PublicAddress publicAddress) {
        return ALTERNATES.get(publicAddress);
    }

    static synchronized void setPreferredAddress(PublicAddress publicAddress, PreferredAddress preferredAddress) {
        ALTERNATES.put(publicAddress, preferredAddress);
        ++_setAlternateCount;
    }

    static synchronized boolean isUnreachable(Address address) {
        return UNREACHABLES.contains(address);
    }

    static synchronized void setUnreachable(Address address, boolean isUnreachable) {
        if (isUnreachable) {
            UNREACHABLES.add(address);
            ++_setUnreachableCount;
        } else {
            UNREACHABLES.remove(address);
        }
    }

    static synchronized void clear() {
        TOPOLOGIES.clear();
        ALTERNATES.clear();
        UNREACHABLES.clear();
    }

    static synchronized int _topologyCount() {
        return TOPOLOGIES.size();
    }

    static synchronized int _alternateCount() {
        return ALTERNATES.size();
    }

    static synchronized int _unreachableCount() {
        return UNREACHABLES.size();
    }

    static synchronized int _topologySetCount() {
        return _setTopologyCount;
    }

    static synchronized int _alternateSetCount() {
        return _setAlternateCount;
    }

    static synchronized int _unreachableSetCount() {
        return _setUnreachableCount;
    }

    static synchronized void _clear() {
        TOPOLOGIES.clear();
        ALTERNATES.clear();
        UNREACHABLES.clear();
        _setTopologyCount = 0;
        _setAlternateCount = 0;
        _setUnreachableCount = 0;
    }

    @ThreadSafe
    static final class TopologyInfo {
        private final SystemInfo _systemInfo;
        private final SiteType _siteType;
        private final SMVRRole _smvrRole;
        private final AtomicInteger _nextAddressCounter;

        private TopologyInfo(SystemInfo systemInfo, SiteType siteType, SMVRRole smvrRole, int currentAddressCounter) {
            this._systemInfo = systemInfo;
            this._siteType = siteType;
            this._smvrRole = smvrRole;
            this._nextAddressCounter = new AtomicInteger(currentAddressCounter);
        }

        SystemInfo getSystemInfo() {
            return this._systemInfo;
        }

        SiteType getSiteType() {
            return this._siteType;
        }

        SMVRRole getSMVRRole() {
            return this._smvrRole;
        }

        int getNextAddressCounter() {
            return this._nextAddressCounter.incrementAndGet();
        }
    }
}

