/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.packet.PartitionMethod;
import java.util.Collections;
import java.util.List;

@Immutable
public final class RangePartitionInfo {
    private final PartitionMethod _partitionMethod;
    private final List<PartitionParameterInfo> _partitionParameterInfoList;
    private final List<RangeInfo> _rangeInfoList;
    private final int _rangeCount;
    private final int _parameterCount;
    private final int _partitionCount;

    public RangePartitionInfo(PartitionMethod partitionMethod, List<PartitionParameterInfo> partitionParameterInfoList, List<RangeInfo> rangeInfoList, int rangeCount, int parameterCount, int partitionCount) {
        this._partitionMethod = partitionMethod;
        this._partitionParameterInfoList = Collections.unmodifiableList(partitionParameterInfoList);
        this._rangeInfoList = Collections.unmodifiableList(rangeInfoList);
        this._rangeCount = rangeCount;
        this._parameterCount = parameterCount;
        this._partitionCount = partitionCount;
    }

    public String toString() {
        return this._toString(-1);
    }

    public PartitionMethod getPartitionMethod() {
        return this._partitionMethod;
    }

    public List<PartitionParameterInfo> getPartitionParameterInfoList() {
        return this._partitionParameterInfoList;
    }

    public List<RangeInfo> getRangeInfoList() {
        return this._rangeInfoList;
    }

    public int getRangeCount() {
        return this._rangeCount;
    }

    public int getParameterCount() {
        return this._parameterCount;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }

    String _toString(int currentTreeNodeNumber) {
        boolean printTreeNodeInfo = currentTreeNodeNumber >= 0;
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder displayString = new StringBuilder();
        displayString.append("\tPartition Type: ").append((Object)this.getPartitionMethod()).append(lineSeparator);
        displayString.append("\tPartition Parameter Information:").append(lineSeparator);
        displayString.append("\t\tPartition Index  Attribute Type  RangeComparisionFunction").append(lineSeparator);
        displayString.append("\t\t---------------------------------------------------------").append(lineSeparator);
        for (PartitionParameterInfo info : this.getPartitionParameterInfoList()) {
            displayString.append(String.format("\t\t%-15s  0x%-12s  %-24s", new Object[]{info.getParameterIndex(), Integer.toHexString(info.getAttributeType() & 0xFF), info.getPartitionParameterFunction()})).append(lineSeparator);
        }
        displayString.append("\tRange Partition Information:").append(lineSeparator);
        displayString.append(String.format("\t\t%-10s %-10s", "Site Type", "Volume ID")).append(lineSeparator);
        displayString.append("\t\t--------------------").append(lineSeparator);
        int rangeIndex = 1;
        for (RangeInfo rangeInfo : this.getRangeInfoList()) {
            displayString.append("\tRange[").append(rangeIndex).append("] ");
            String floor = "<unset>";
            String ceiling = "<unset>";
            if (rangeInfo.getStringFloor() != null) {
                floor = rangeInfo.getStringFloor();
                ceiling = rangeInfo.getStringCeil();
            } else if (rangeInfo.getLongFloor() != -1L) {
                floor = Long.toString(rangeInfo.getLongFloor());
                ceiling = Long.toString(rangeInfo.getLongCeil());
            } else if (rangeInfo.getBdFloor() != null) {
                floor = rangeInfo.getBdFloor().toString();
                String string = ceiling = rangeInfo.getBdCeil() != null ? rangeInfo.getBdCeil().toString() : "";
            }
            if (rangeInfo.isMultiValueRange()) {
                if (rangeInfo.isRestRange()) {
                    displayString.append("Rest:").append(lineSeparator);
                } else {
                    displayString.append("Multi-Value [").append(floor).append(", ").append(ceiling).append("):").append(lineSeparator);
                }
            } else {
                displayString.append("Single-Value {").append(floor).append("}:").append(lineSeparator);
            }
            for (SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID : rangeInfo.getSiteTypeReplicaRoleVolumeIDs()) {
                if (siteTypeReplicaRoleVolumeID.isSubpartition()) {
                    if (printTreeNodeInfo) {
                        displayString.append("\t\tSub Partition found. Expected Tree Node: ").append(++currentTreeNodeNumber).append(lineSeparator);
                        continue;
                    }
                    displayString.append("\t\tSub Partition found").append(currentTreeNodeNumber).append(lineSeparator);
                    continue;
                }
                displayString.append("\t\t").append(String.format("%-10s %-10s", siteTypeReplicaRoleVolumeID.getSiteType(), siteTypeReplicaRoleVolumeID.getVolumeID())).append(lineSeparator);
            }
            ++rangeIndex;
        }
        return displayString.toString();
    }
}

