/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.packet.PartitionMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Immutable
public final class HashPartitionInfo {
    private final PartitionMethod _partitionMethod;
    private final List<PartitionParameterInfo> _partitionParameterInfoList;
    private final Map<Integer, List<SiteTypeReplicaRoleVolumeID>> _partitionAssignmentMap;
    private final int _rangeCount;
    private final int _parameterCount;
    private final int _partitionCount;

    public HashPartitionInfo(PartitionMethod partitionMethod, List<PartitionParameterInfo> partitionParameterInfoList, Map<Integer, List<SiteTypeReplicaRoleVolumeID>> partitionAssignmentMap, int rangeCount, int parameterCount, int partitionCount) {
        this._partitionMethod = partitionMethod;
        this._partitionParameterInfoList = Collections.unmodifiableList(partitionParameterInfoList);
        this._partitionAssignmentMap = Collections.unmodifiableMap(partitionAssignmentMap);
        this._rangeCount = rangeCount;
        this._parameterCount = parameterCount;
        this._partitionCount = partitionCount;
    }

    public String toString() {
        return this._toString(-1);
    }

    public PartitionMethod getPartitionMethod() {
        return this._partitionMethod;
    }

    public List<PartitionParameterInfo> getPartitionParameterInfoList() {
        return this._partitionParameterInfoList;
    }

    public Map<Integer, List<SiteTypeReplicaRoleVolumeID>> getPartitionAssignmentMap() {
        return this._partitionAssignmentMap;
    }

    public int getRangeCount() {
        return this._rangeCount;
    }

    public int getParameterCount() {
        return this._parameterCount;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }

    String _toString(int currentTreeNodeNumber) {
        boolean printTreeNodeInfo = currentTreeNodeNumber >= 0;
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder displayString = new StringBuilder();
        displayString.append("\tPartition Type: ").append((Object)this.getPartitionMethod()).append(lineSeparator);
        displayString.append("\tPartition Parameter Information:").append(lineSeparator);
        displayString.append("\t\tPartition Index  Attribute Type  PartitionParameterFunction").append(lineSeparator);
        displayString.append("\t\t-----------------------------------------------------------").append(lineSeparator);
        for (PartitionParameterInfo partitionParameterInfo : this.getPartitionParameterInfoList()) {
            displayString.append(String.format("\t\t%-15s  0x%-12s  %-26s", new Object[]{partitionParameterInfo.getParameterIndex(), Integer.toHexString(partitionParameterInfo.getAttributeType() & 0xFF), partitionParameterInfo.getPartitionParameterFunction()})).append(lineSeparator);
        }
        displayString.append("\tRange Partition Information:").append(lineSeparator);
        displayString.append(String.format("\t\t%-10s %-10s %-10s", "Part#", "Site Type", "Volume ID")).append(lineSeparator);
        displayString.append("\t\t-------------------------------").append(lineSeparator);
        for (Map.Entry entry : this.getPartitionAssignmentMap().entrySet()) {
            displayString.append(String.format("\t\t%-10d ", entry.getKey()));
            for (SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID : (List)entry.getValue()) {
                if (siteTypeReplicaRoleVolumeID.isSubpartition()) {
                    if (printTreeNodeInfo) {
                        displayString.append("\t\tSub Partition found. Expected Tree Node: ").append(++currentTreeNodeNumber).append(lineSeparator);
                        continue;
                    }
                    displayString.append("\t\tSub Partition found").append(currentTreeNodeNumber).append(lineSeparator);
                    continue;
                }
                displayString.append(String.format("\t\t%-10s %-10s", siteTypeReplicaRoleVolumeID.getSiteType(), siteTypeReplicaRoleVolumeID.getVolumeID())).append(lineSeparator);
            }
        }
        return displayString.toString();
    }
}

