/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.JdbcObject;
import java.sql.SQLException;

@NotThreadSafe
public abstract class AbstractClientLob
extends JdbcObject {
    protected final ConnectionSapDB _connection;
    protected final Tracer _tracer;

    protected AbstractClientLob(ConnectionSapDB connection) {
        this._connection = connection;
        this._tracer = connection.getTracer();
    }

    protected static SQLException _getUnsupportedMethodException(String className, String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, className);
    }

    protected static void _checkFreed(Object data) throws SQLException {
        if (data == null) {
            throw SQLExceptionSapDB.newInstance("error.objectisfreed", new String[0]);
        }
    }

    protected static void _checkLength(int dataLen, long len) throws SQLException {
        if (len < 0L || len > (long)dataLen) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.length", String.valueOf(dataLen));
        }
    }

    protected static void _checkGetPositionAndLength(int dataLen, long pos, long len) throws SQLException {
        long maxPos = dataLen + 1;
        if (pos < 1L || pos > maxPos) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.get.position", String.valueOf(maxPos));
        }
        long maxLen = Math.min((long)dataLen - pos + 1L, Integer.MAX_VALUE);
        if (len < 0L || len > maxLen) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.length", String.valueOf(maxLen));
        }
    }

    protected static void _checkSetPosition(long pos) throws SQLException {
        if (pos < 1L) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.set.position", new String[0]);
        }
    }

    protected static void _checkSourceOffsetAndLength(int srcLen, long off, long len) throws SQLException {
        long maxLen;
        int maxOff;
        int n = maxOff = srcLen > 0 ? srcLen - 1 : 0;
        if (off < 0L || off > (long)maxOff) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.source.offset", String.valueOf(maxOff));
        }
        long l = maxLen = srcLen > 0 ? Math.min((long)srcLen - off, Integer.MAX_VALUE) : 0L;
        if (len < 0L || len > maxLen) {
            throw SQLExceptionSapDB.newInstance("error.invalid.lob.source.length", String.valueOf(maxLen));
        }
    }

    protected static void _checkValidCharacterForClob(int c) throws SQLException {
        if (c > 127) {
            throw SQLExceptionSapDB.newInstance("error.invalid.character.for.clob", String.valueOf((char)c));
        }
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, null, null, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }
}

