/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

@Immutable
public final class Dbg {
    public static final boolean on = false;
    public static final boolean runtimeEnabled;
    public static final boolean ignoredException = false;
    public static final boolean authentication = false;
    public static final boolean sockets = false;
    public static final boolean sessions = false;
    public static final boolean close = false;
    public static final boolean finalize = false;
    public static final boolean clean = false;
    public static final boolean locks = false;
    public static final boolean inputArgs = false;
    public static final boolean hexPacketDump = false;
    public static final boolean compression = false;
    public static final boolean dynamicFetchSize = false;
    public static final boolean topology = false;
    public static final boolean sslHandshake = false;
    public static final boolean sslSend = false;
    public static final boolean sslReceive = false;
    public static final boolean topologyVerbose = false;
    public static final boolean traceConnections = false;
    public static final boolean heartbeat = false;
    public static final boolean channels = false;
    public static final boolean api = false;
    private static final PrintStream STREAM;
    private static final int BUFFER_SIZE = 4096;
    private static final int INDENT = 4;
    private static final ThreadLocal<ApiDepth> API_DEPTH;

    private Dbg() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void print(String text) {
        STREAM.print(text);
    }

    public static void println(String text) {
        STREAM.println(text);
    }

    public static void printf(String format, Object ... args) {
        STREAM.printf(format, args);
    }

    public static void printlnEx(Throwable t, String text) {
        StringBuilder builder = new StringBuilder(4096);
        Dbg._formatThrowable(builder, t);
        STREAM.println(text + builder);
    }

    public static void printClassHeirarchy(String name, Object object) {
        Dbg.printClassHeirarchy(name, object.getClass());
    }

    public static void printClassHeirarchy(String name, Class<?> clas) {
        Dbg.println(name + ":");
        Dbg._printClassHeirarchy(clas, 0);
    }

    public static String hexDump(byte[] bytes) {
        return Dbg.hexDump(bytes, 0, bytes.length);
    }

    public static String hexDump(byte[] bytes, int off, int len) {
        if (bytes == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(65536);
        StringBuilder hex = new StringBuilder(48);
        StringBuilder ascii = new StringBuilder(16);
        int offset = -1;
        int i = off;
        int j = 0;
        int n = off + len;
        while (i < n) {
            byte b = bytes[i];
            hex.append(String.format("%02X ", b));
            ascii.append(b >= 32 && b < 127 ? (char)b : (char)'.');
            switch (j % 16) {
                case 0: {
                    offset = j;
                    break;
                }
                case 15: {
                    builder.append(Dbg._hexDumpFormatLine(offset, hex.toString(), ascii.toString()));
                    hex.setLength(0);
                    ascii.setLength(0);
                }
            }
            ++i;
            ++j;
        }
        if (hex.length() > 0) {
            builder.append(Dbg._hexDumpFormatLine(offset, hex.toString(), ascii.toString()));
        }
        return builder.toString();
    }

    public static void apiEnter() {
    }

    public static void apiExit() {
    }

    private static String _hexDumpFormatLine(int offset, String hex, String ascii) {
        return String.format("%10d | %8X | %-48s| %-16s |\n", offset, offset, hex, ascii);
    }

    private static void _formatThrowable(StringBuilder builder, Throwable t) {
        StringWriter stringWriter = new StringWriter(4096);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            builder.append("\nSQLState  = ").append(sqle.getSQLState());
            builder.append("\nErrorCode = ").append(sqle.getErrorCode());
        }
        t.printStackTrace(printWriter);
        printWriter.flush();
        builder.append('\n');
        builder.append(stringWriter);
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            builder.append("\nThis exception was caused by:");
            Dbg._formatThrowable(builder, cause);
        }
    }

    private static void _printClassHeirarchy(Class<?> clas, int indent) {
        if (clas == null) {
            return;
        }
        boolean isInterface = clas.isInterface();
        Dbg.printf("%" + (indent > 0 ? String.valueOf(indent) : "") + "s%s%s%s\n", "", isInterface ? "[" : "", clas.getCanonicalName(), isInterface ? "]" : "");
        indent += 4;
        for (Class<?> i : clas.getInterfaces()) {
            Dbg._printClassHeirarchy(i, indent);
        }
        Dbg._printClassHeirarchy(clas.getSuperclass(), indent);
    }

    static {
        boolean isCompileTimeEnabled = false;
        boolean isSystemPropertySet = false;
        boolean isEnvironmentVariableSet = false;
        if (!isCompileTimeEnabled) {
            try {
                isSystemPropertySet = System.getProperty("_HANA_JDBC_DEBUG_ENABLED_") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!isSystemPropertySet) {
                try {
                    isEnvironmentVariableSet = System.getenv("_HANA_JDBC_DEBUG_ENABLED_") != null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        runtimeEnabled = isCompileTimeEnabled || isSystemPropertySet || isEnvironmentVariableSet;
        STREAM = System.err;
        API_DEPTH = ThreadLocal.withInitial(() -> new ApiDepth());
    }

    private static class ApiDepth {
        private int _depth;

        private ApiDepth() {
        }
    }
}

