/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.HexUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class RealConverter
extends AbstractNumericConverter {
    private static final Float MIN_VALUE = Float.valueOf(-3.4028235E38f);
    private static final Float MAX_VALUE = Float.valueOf(Float.MAX_VALUE);
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MIN_VALUE.floatValue());
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = BigDecimal.valueOf(MAX_VALUE.floatValue());

    protected RealConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 1;
        }
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Float)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Float)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        float value = ((Float)data).floatValue();
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putFloat(value, new byte[4], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putFloatAsReal(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putInt(-1, new byte[4], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Float.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Float.valueOf(this._getValueAsFloat(controller, dataPart, false, decrypted, null));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true, null, outIsNull) != 0.0f;
    }

    @Override
    public Float setBoolean(boolean value) throws SQLException {
        return Float.valueOf(value ? 1 : 0);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (byte)this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setByte(byte value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (short)this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setShort(short value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (int)this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setInt(int value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (long)this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setLong(long value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw RealConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < MIN_VALUE.floatValue() || value > MAX_VALUE.floatValue()) {
            throw RealConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return Float.valueOf(value);
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Float setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw RealConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        if (value < (double)MIN_VALUE.floatValue() || value > (double)MAX_VALUE.floatValue()) {
            throw RealConverter._newSetNumericValueOutOfRangeException(String.valueOf(value), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return Float.valueOf((float)value);
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : BigDecimal.valueOf(this._getValueAsFloat(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Float setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
            throw RealConverter._newSetNumericValueOutOfRangeException(value.toPlainString(), String.valueOf(MIN_VALUE), String.valueOf(MAX_VALUE));
        }
        return Float.valueOf(value.floatValue());
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsFloat(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Float setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            float f = Float.parseFloat(value.trim());
            if (Float.isNaN(f) || Float.isInfinite(f)) {
                throw RealConverter._newSetConversionException(value, "float");
            }
            return Float.valueOf(f);
        }
        catch (NumberFormatException e) {
            throw RealConverter._newSetConversionException(value, "float");
        }
    }

    @Override
    public Float setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(HexUtils.toDisplayHexString(value));
        }
        return Float.valueOf(value[0] & 0xFF);
    }

    private float _getValueAsFloat(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return 0.0f;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getFloat(decrypted, 0);
        }
        return dataPart.getRealAsFloat();
    }
}

