/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.CSECipherFactory;
import com.sap.db.util.CSEStreamCipher;
import com.sap.db.util.OutputBuffer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.SQLException;

@Immutable
public final class ClientKeyPair {
    private final byte[] _publicKeyBytes;
    private final byte[] _privateKeyBytes;
    private final PublicKey _publicKey;
    private final PrivateKey _privateKey;
    private final String _dbName;
    private final String _keyName;
    private final String _keyUuid;
    private final String _algorithmName;

    public static ClientKeyPair newInstance(KeyPair key, String dbName, String keyName, String keyUuid, String algorithmName) {
        return new ClientKeyPair(key.getPublic().getEncoded(), key.getPrivate().getEncoded(), key.getPublic(), key.getPrivate(), dbName, keyName, keyUuid, algorithmName);
    }

    public static ClientKeyPair newInstance(byte[] publicKeyBytes, byte[] privateKeyBytes, String dbName, String keyName, String keyUuid, String algorithmName) throws SQLException {
        CSEStreamCipher streamCipher = CSECipherFactory.getStreamCipher(algorithmName);
        return new ClientKeyPair(publicKeyBytes, privateKeyBytes, streamCipher.generatePublicKeyFromBytes(publicKeyBytes, algorithmName), streamCipher.generatePrivateKeyFromBytes(privateKeyBytes, algorithmName), dbName, keyName, keyUuid, algorithmName);
    }

    private ClientKeyPair(byte[] publicKeyBytes, byte[] privateKeyBytes, PublicKey publicKey, PrivateKey privateKey, String dbName, String keyName, String keyUuid, String algorithmName) {
        this._publicKeyBytes = publicKeyBytes;
        this._publicKey = publicKey;
        this._privateKeyBytes = privateKeyBytes;
        this._privateKey = privateKey;
        this._dbName = dbName;
        this._keyName = keyName;
        this._keyUuid = keyUuid;
        this._algorithmName = algorithmName;
    }

    public String toString() {
        return "Public key: " + (this._publicKey != null ? this._publicKey.toString() : "null") + " Private key: " + (this._privateKey != null ? this._privateKey.toString() : "null") + " Database name: " + this._dbName + " Key name: " + this._keyName + " Key UUID: " + this._keyUuid + " Algorithm name: " + this._algorithmName;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public String getKeyName() {
        return this._keyName;
    }

    public String getKeyUuid() {
        return this._keyUuid;
    }

    public String getAlgorithmName() {
        return this._algorithmName;
    }

    public OutputBuffer getClientKeyPairBytes() throws SQLException {
        OutputBuffer outputBuffer;
        byte[] dbBytes = this._dbName.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = this._keyName.getBytes(StandardCharsets.UTF_8);
        byte[] uuidBytes = this._keyUuid.getBytes(StandardCharsets.UTF_8);
        byte[] lengthBuffer = new byte[2];
        try {
            outputBuffer = new OutputBuffer(this._publicKeyBytes.length + this._privateKeyBytes.length + dbBytes.length + keyBytes.length + uuidBytes.length);
            outputBuffer.write(ByteUtils.putShortBigEndian((short)this._publicKeyBytes.length, lengthBuffer, 0));
            outputBuffer.write(this._publicKeyBytes);
            outputBuffer.write(ByteUtils.putShortBigEndian((short)this._privateKeyBytes.length, lengthBuffer, 0));
            outputBuffer.write(this._privateKeyBytes);
            outputBuffer.write(ByteUtils.putShortBigEndian((short)dbBytes.length, lengthBuffer, 0));
            outputBuffer.write(dbBytes);
            outputBuffer.write(ByteUtils.putShortBigEndian((short)keyBytes.length, lengthBuffer, 0));
            outputBuffer.write(keyBytes);
            outputBuffer.write(ByteUtils.putShortBigEndian((short)uuidBytes.length, lengthBuffer, 0));
            outputBuffer.write(uuidBytes);
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.invalidclientkeypair", new String[0]);
        }
        return outputBuffer;
    }
}

