/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.sap.cds.UserContext;
import java.time.Instant;
import java.util.Locale;

public final class SessionContext {
    private final UserContext userContext;
    private final Instant now;
    private final Instant validTo;
    private final Instant validFrom;

    private SessionContext(Builder builder) {
        this.userContext = builder.userContext;
        this.now = builder.now;
        this.validTo = builder.validTo;
        this.validFrom = builder.validFrom;
    }

    public static Builder create() {
        return new Builder();
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public Instant getNow() {
        return this.now != null ? this.now : Instant.now();
    }

    public Instant getValidTo() {
        return this.validTo;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Locale getLocale() {
        return this.userContext.getLocale();
    }

    public static class Builder {
        private UserContext userContext;
        private Instant now;
        private Instant validTo;
        private Instant validFrom;

        public Builder() {
            this(UserContext.create().build(), null, null, null);
        }

        public Builder(UserContext userContext, Instant now, Instant validTo, Instant validFrom) {
            this.userContext = userContext;
            this.now = now;
            this.validTo = validTo;
            this.validFrom = validFrom;
        }

        public Builder setUserContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public Builder setNow(Instant now) {
            this.now = now;
            return this;
        }

        public Builder setValidTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public Builder setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public SessionContext build() {
            return new SessionContext(this);
        }
    }
}

