/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.MediaActionSound;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.content.ContextCompat;
import com.sandrios.sandriosCamera.R;
import com.sandrios.sandriosCamera.internal.utils.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RecordButton
extends AppCompatImageButton {
    public static final int TAKE_PHOTO_STATE = 0;
    public static final int READY_FOR_RECORD_STATE = 1;
    public static final int RECORD_IN_PROGRESS_STATE = 2;
    private Context context;
    private int mediaAction = 101;
    private int currentState = 0;
    private Drawable takePhotoDrawable;
    private Drawable startRecordDrawable;
    private Drawable stopRecordDrawable;
    private int iconPadding = 8;
    private int iconPaddingStop = 18;
    private RecordButtonListener listener;

    public RecordButton(@NonNull Context context) {
        this(context, null, 0);
    }

    public RecordButton(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecordButton(@NonNull Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.takePhotoDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.take_photo_button);
        this.startRecordDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.start_video_record_button);
        this.stopRecordDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.stop_button_background);
    }

    public void setup(int mediaAction, @NonNull RecordButtonListener listener) {
        this.setMediaAction(mediaAction);
        this.listener = listener;
        if (Build.VERSION.SDK_INT > 15) {
            this.setBackground(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.circle_frame_background));
        } else {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.circle_frame_background));
        }
        this.setIcon();
        this.setOnClickListener(new RecordClickListener());
        this.setSoundEffectsEnabled(false);
        this.setIconPadding(this.iconPadding);
    }

    private void setIconPadding(int paddingDP) {
        int padding = Utils.convertDpToPixel(paddingDP);
        this.setPadding(padding, padding, padding, padding);
    }

    public void setMediaAction(int mediaAction) {
        this.mediaAction = mediaAction;
        this.currentState = 101 == mediaAction ? 0 : 1;
        this.setRecordState(this.currentState);
        this.setIcon();
    }

    public int getRecordState() {
        return this.currentState;
    }

    public void setRecordState(int state) {
        this.currentState = state;
        this.setIcon();
    }

    public void setRecordButtonListener(@NonNull RecordButtonListener listener) {
        this.listener = listener;
    }

    private void setIcon() {
        if (100 == this.mediaAction) {
            if (1 == this.currentState) {
                this.setImageDrawable(this.startRecordDrawable);
                this.setIconPadding(this.iconPadding);
            } else if (2 == this.currentState) {
                this.setImageDrawable(this.stopRecordDrawable);
                this.setIconPadding(this.iconPaddingStop);
            }
        } else {
            this.setImageDrawable(this.takePhotoDrawable);
            this.setIconPadding(this.iconPadding);
        }
    }

    @TargetApi(value=21)
    private void takePhoto(MediaActionSound sound) {
        sound.play(0);
        this.takePhoto();
    }

    private void takePhoto() {
        if (this.listener != null) {
            this.listener.onTakePhotoButtonPressed();
        }
    }

    @TargetApi(value=21)
    private void startRecording(MediaActionSound sound) {
        sound.play(2);
        this.startRecording();
    }

    private void startRecording() {
        this.currentState = 2;
        if (this.listener != null) {
            this.listener.onStartRecordingButtonPressed();
        }
    }

    @TargetApi(value=21)
    private void stopRecording(MediaActionSound sound) {
        sound.play(3);
        this.stopRecording();
    }

    private void stopRecording() {
        this.currentState = 1;
        if (this.listener != null) {
            this.listener.onStopRecordingButtonPressed();
        }
    }

    private class RecordClickListener
    implements View.OnClickListener {
        private static final int CLICK_DELAY = 1000;
        private long lastClickTime = 0L;

        private RecordClickListener() {
        }

        public void onClick(View view) {
            if (System.currentTimeMillis() - this.lastClickTime < 1000L) {
                return;
            }
            this.lastClickTime = System.currentTimeMillis();
            if (Build.VERSION.SDK_INT > 15) {
                MediaActionSound sound = new MediaActionSound();
                if (0 == RecordButton.this.currentState) {
                    RecordButton.this.takePhoto(sound);
                } else if (1 == RecordButton.this.currentState) {
                    RecordButton.this.startRecording(sound);
                } else if (2 == RecordButton.this.currentState) {
                    RecordButton.this.stopRecording(sound);
                }
            } else if (0 == RecordButton.this.currentState) {
                RecordButton.this.takePhoto();
            } else if (1 == RecordButton.this.currentState) {
                RecordButton.this.startRecording();
            } else if (2 == RecordButton.this.currentState) {
                RecordButton.this.stopRecording();
            }
            RecordButton.this.setIcon();
        }
    }

    public static interface RecordButtonListener {
        public void onTakePhotoButtonPressed();

        public void onStartRecordingButtonPressed();

        public void onStopRecordingButtonPressed();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordState {
    }
}

