/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.sandrios.sandriosCamera.internal.ui.camera.Camera1Activity;
import com.sandrios.sandriosCamera.internal.ui.camera2.Camera2Activity;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;

public class SandriosCamera {
    public static int RESULT_CODE = 956;
    public static String MEDIA = "media";
    private static SandriosCamera mInstance = null;
    private int mediaAction = 102;
    private boolean showPicker = true;
    private boolean autoRecord = false;
    private boolean enableImageCrop = false;
    private long videoSize = -1L;

    public static SandriosCamera with() {
        if (mInstance == null) {
            mInstance = new SandriosCamera();
        }
        return mInstance;
    }

    public SandriosCamera setShowPicker(boolean showPicker) {
        this.showPicker = showPicker;
        return mInstance;
    }

    public SandriosCamera setMediaAction(int mediaAction) {
        this.mediaAction = mediaAction;
        return mInstance;
    }

    public SandriosCamera enableImageCropping(boolean enableImageCrop) {
        this.enableImageCrop = enableImageCrop;
        return mInstance;
    }

    public SandriosCamera setVideoFileSize(int fileSize) {
        this.videoSize = fileSize;
        return mInstance;
    }

    public SandriosCamera setAutoRecord() {
        this.autoRecord = true;
        return mInstance;
    }

    public void launchCamera(Activity activity) {
        if (CameraHelper.hasCamera((Context)activity)) {
            Intent cameraIntent = CameraHelper.hasCamera2((Context)activity) ? new Intent((Context)activity, Camera2Activity.class) : new Intent((Context)activity, Camera1Activity.class);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.show_picker", this.showPicker);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.media_action", this.mediaAction);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.enable_crop", this.enableImageCrop);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.auto_record", this.autoRecord);
            if (this.videoSize > 0L) {
                cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_video_file_size", this.videoSize * 1024L * 1024L);
            }
            activity.startActivityForResult(cameraIntent, RESULT_CODE);
        }
    }

    public class MediaType {
        public static final int PHOTO = 0;
        public static final int VIDEO = 1;
    }
}

