/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.utils;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;

public class RecyclerItemClickListener
implements RecyclerView.OnItemTouchListener {
    private GestureDetector mGestureDetector;
    private OnClickListener mListener;

    public RecyclerItemClickListener(Context context, OnClickListener listener) {
        this.mListener = listener;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }
        });
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null && this.mListener != null && this.mGestureDetector.onTouchEvent(e)) {
            this.mListener.onItemClick(childView, view.getChildAdapterPosition(childView));
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public static interface OnClickListener {
        public void onItemClick(View var1, int var2);
    }
}

