/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.media.CamcorderProfile;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.sandrios.sandriosCamera.internal.utils.Size;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class CameraHelper {
    public static final String TAG = "CameraHelper";

    private CameraHelper() {
    }

    public static boolean hasCamera(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera") || context.getPackageManager().hasSystemFeature("android.hardware.camera.front");
    }

    @TargetApi(value=21)
    public static boolean hasCamera2(Context context) {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        try {
            CameraManager manager = (CameraManager)context.getSystemService("camera");
            String[] idList = manager.getCameraIdList();
            boolean notNull = true;
            if (idList.length == 0) {
                notNull = false;
            } else {
                for (String str : idList) {
                    if (str == null || str.trim().isEmpty()) {
                        notNull = false;
                        break;
                    }
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(str);
                    int supportLevel = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                    if (supportLevel != 2) continue;
                    notNull = false;
                    break;
                }
            }
            return notNull;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static File getOutputMediaFile(Context context, int mediaAction) {
        File mediaFile;
        File mediaStorageDir = context.getFilesDir();
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            Log.d((String)TAG, (String)"Failed to create directory.");
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.ENGLISH).format(new Date());
        if (mediaAction == 101) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        } else if (mediaAction == 100) {
            mediaFile = new File(mediaStorageDir.getPath() + File.separator + "VID_" + timeStamp + ".mp4");
        } else {
            return null;
        }
        return mediaFile;
    }

    public static Size getPictureSize(List<Size> choices, int mediaQuality) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        if (choices.size() == 1) {
            return choices.get(0);
        }
        Size result = null;
        Size maxPictureSize = Collections.max(choices, new CompareSizesByArea2());
        Size minPictureSize = Collections.min(choices, new CompareSizesByArea2());
        Collections.sort(choices, new CompareSizesByArea2());
        if (mediaQuality == 14) {
            result = maxPictureSize;
        } else if (mediaQuality == 11) {
            if (choices.size() == 2) {
                result = minPictureSize;
            } else {
                int half = choices.size() / 2;
                int lowQualityIndex = (choices.size() - half) / 2;
                result = choices.get(lowQualityIndex + 1);
            }
        } else if (mediaQuality == 13) {
            if (choices.size() == 2) {
                result = maxPictureSize;
            } else {
                int half = choices.size() / 2;
                int highQualityIndex = (choices.size() - half) / 2;
                result = choices.get(choices.size() - highQualityIndex - 1);
            }
        } else if (mediaQuality == 12) {
            if (choices.size() == 2) {
                result = minPictureSize;
            } else {
                int mediumQualityIndex = choices.size() / 2;
                result = choices.get(mediumQualityIndex);
            }
        } else if (mediaQuality == 15) {
            result = minPictureSize;
        }
        return result;
    }

    @TargetApi(value=21)
    public static Size getPictureSize(Size[] sizes, int mediaQuality) {
        if (sizes == null || sizes.length == 0) {
            return null;
        }
        List<Size> choices = Arrays.asList(sizes);
        if (choices.size() == 1) {
            return choices.get(0);
        }
        Size result = null;
        Size maxPictureSize = Collections.max(choices, new CompareSizesByArea2());
        Size minPictureSize = Collections.min(choices, new CompareSizesByArea2());
        Collections.sort(choices, new CompareSizesByArea2());
        if (mediaQuality == 14) {
            result = maxPictureSize;
        } else if (mediaQuality == 11) {
            if (choices.size() == 2) {
                result = minPictureSize;
            } else {
                int half = choices.size() / 2;
                int lowQualityIndex = (choices.size() - half) / 2;
                result = choices.get(lowQualityIndex + 1);
            }
        } else if (mediaQuality == 13) {
            if (choices.size() == 2) {
                result = maxPictureSize;
            } else {
                int half = choices.size() / 2;
                int highQualityIndex = (choices.size() - half) / 2;
                result = choices.get(choices.size() - highQualityIndex - 1);
            }
        } else if (mediaQuality == 12) {
            if (choices.size() == 2) {
                result = minPictureSize;
            } else {
                int mediumQualityIndex = choices.size() / 2;
                result = choices.get(mediumQualityIndex);
            }
        } else if (mediaQuality == 15) {
            result = minPictureSize;
        }
        return result;
    }

    public static Size getOptimalPreviewSize(List<Size> sizes, int width, int height) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)height / (double)width;
        if (sizes == null) {
            return null;
        }
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = height;
        for (Size size : sizes) {
            double ratio = (double)size.getWidth() / (double)size.getHeight();
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - targetHeight);
            }
        }
        return optimalSize;
    }

    public static Size getSizeWithClosestRatio(List<Size> sizes, int width, int height) {
        if (sizes == null) {
            return null;
        }
        double MIN_TOLERANCE = 100.0;
        double targetRatio = (double)height / (double)width;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = height;
        for (Size size : sizes) {
            if (size.getWidth() == width && size.getHeight() == height) {
                return size;
            }
            double ratio = (double)size.getHeight() / (double)size.getWidth();
            if (!(Math.abs(ratio - targetRatio) < MIN_TOLERANCE)) continue;
            MIN_TOLERANCE = ratio;
            if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - targetHeight);
            }
        }
        return optimalSize;
    }

    @TargetApi(value=21)
    public static Size getOptimalPreviewSize(Size[] sizes, int width, int height) {
        if (sizes == null) {
            return null;
        }
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)height / (double)width;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = height;
        for (Size size : sizes) {
            double ratio = (double)size.getWidth() / (double)size.getHeight();
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - targetHeight);
            }
        }
        return optimalSize;
    }

    @TargetApi(value=21)
    public static Size getSizeWithClosestRatio(Size[] sizes, int width, int height) {
        if (sizes == null) {
            return null;
        }
        double MIN_TOLERANCE = 100.0;
        double targetRatio = (double)height / (double)width;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = height;
        for (Size size : sizes) {
            double ratio = (double)size.getHeight() / (double)size.getWidth();
            if (!(Math.abs(ratio - targetRatio) < MIN_TOLERANCE)) continue;
            MIN_TOLERANCE = ratio;
            if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - targetHeight);
            }
        }
        return optimalSize;
    }

    @TargetApi(value=21)
    public static Size chooseOptimalSize(Size[] choices, int width, int height, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getHeight() != option.getWidth() * h / w || option.getWidth() < width || option.getHeight() < height) continue;
            bigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea2());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return null;
    }

    private static double calculateApproximateVideoSize(CamcorderProfile camcorderProfile, int seconds) {
        return ((float)camcorderProfile.videoBitRate / 1.0f + (float)camcorderProfile.audioBitRate / 1.0f) * (float)seconds / 8.0f;
    }

    public static double calculateApproximateVideoDuration(CamcorderProfile camcorderProfile, long maxFileSize) {
        return 8L * maxFileSize / (long)(camcorderProfile.videoBitRate + camcorderProfile.audioBitRate);
    }

    private static long calculateMinimumRequiredBitRate(CamcorderProfile camcorderProfile, long maxFileSize, int seconds) {
        return 8L * maxFileSize / (long)seconds - (long)camcorderProfile.audioBitRate;
    }

    @TargetApi(value=21)
    public static CamcorderProfile getCamcorderProfile(String cameraId, long maximumFileSize, int minimumDurationInSeconds) {
        if (TextUtils.isEmpty((CharSequence)cameraId)) {
            return null;
        }
        int cameraIdInt = Integer.parseInt(cameraId);
        return CameraHelper.getCamcorderProfile(cameraIdInt, maximumFileSize, minimumDurationInSeconds);
    }

    public static CamcorderProfile getCamcorderProfile(int currentCameraId, long maximumFileSize, int minimumDurationInSeconds) {
        if (maximumFileSize <= 0L) {
            return CamcorderProfile.get((int)currentCameraId, (int)14);
        }
        int[] qualities = new int[]{14, 13, 12, 11, 15};
        for (int i = 0; i < qualities.length; ++i) {
            CamcorderProfile camcorderProfile = CameraHelper.getCamcorderProfile(qualities[i], currentCameraId);
            double fileSize = CameraHelper.calculateApproximateVideoSize(camcorderProfile, minimumDurationInSeconds);
            if (fileSize > (double)maximumFileSize) {
                long minimumRequiredBitRate = CameraHelper.calculateMinimumRequiredBitRate(camcorderProfile, maximumFileSize, minimumDurationInSeconds);
                if (minimumRequiredBitRate < (long)(camcorderProfile.videoBitRate / 4) || minimumRequiredBitRate > (long)camcorderProfile.videoBitRate) continue;
                camcorderProfile.videoBitRate = (int)minimumRequiredBitRate;
                return camcorderProfile;
            }
            return camcorderProfile;
        }
        return CameraHelper.getCamcorderProfile(15, currentCameraId);
    }

    @TargetApi(value=21)
    public static CamcorderProfile getCamcorderProfile(int mediaQuality, String cameraId) {
        if (TextUtils.isEmpty((CharSequence)cameraId)) {
            return null;
        }
        int cameraIdInt = Integer.parseInt(cameraId);
        return CameraHelper.getCamcorderProfile(mediaQuality, cameraIdInt);
    }

    public static CamcorderProfile getCamcorderProfile(int mediaQuality, int cameraId) {
        if (Build.VERSION.SDK_INT > 10) {
            if (mediaQuality == 14) {
                return CamcorderProfile.get((int)cameraId, (int)1);
            }
            if (mediaQuality == 13) {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)6)) {
                    return CamcorderProfile.get((int)cameraId, (int)6);
                }
                if (CamcorderProfile.hasProfile((int)cameraId, (int)5)) {
                    return CamcorderProfile.get((int)cameraId, (int)5);
                }
                return CamcorderProfile.get((int)cameraId, (int)1);
            }
            if (mediaQuality == 12) {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)5)) {
                    return CamcorderProfile.get((int)cameraId, (int)5);
                }
                if (CamcorderProfile.hasProfile((int)cameraId, (int)4)) {
                    return CamcorderProfile.get((int)cameraId, (int)4);
                }
                return CamcorderProfile.get((int)cameraId, (int)0);
            }
            if (mediaQuality == 11) {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)4)) {
                    return CamcorderProfile.get((int)cameraId, (int)4);
                }
                return CamcorderProfile.get((int)cameraId, (int)0);
            }
            if (mediaQuality == 15) {
                return CamcorderProfile.get((int)cameraId, (int)0);
            }
            return CamcorderProfile.get((int)cameraId, (int)1);
        }
        if (mediaQuality == 14) {
            return CamcorderProfile.get((int)cameraId, (int)1);
        }
        if (mediaQuality == 13) {
            return CamcorderProfile.get((int)cameraId, (int)1);
        }
        if (mediaQuality == 12) {
            return CamcorderProfile.get((int)cameraId, (int)0);
        }
        if (mediaQuality == 11) {
            return CamcorderProfile.get((int)cameraId, (int)0);
        }
        if (mediaQuality == 15) {
            return CamcorderProfile.get((int)cameraId, (int)0);
        }
        return CamcorderProfile.get((int)cameraId, (int)1);
    }

    @TargetApi(value=21)
    private static class CompareSizesByArea2
    implements Comparator<Size> {
        private CompareSizesByArea2() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

