/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.utils;

import android.annotation.TargetApi;
import android.media.Image;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ImageSaver
implements Runnable {
    private static final String TAG = "ImageSaver";
    private final Image image;
    private final File file;
    private ImageSaverCallback imageSaverCallback;

    public ImageSaver(Image image, File file, ImageSaverCallback imageSaverCallback) {
        this.image = image;
        this.file = file;
        this.imageSaverCallback = imageSaverCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=19)
    public void run() {
        ByteBuffer buffer = this.image.getPlanes()[0].getBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.file);
            output.write(bytes);
            this.imageSaverCallback.onSuccessFinish();
        }
        catch (IOException ignore) {
            Log.e((String)TAG, (String)"Can't save the image file.");
            this.imageSaverCallback.onError();
        }
        finally {
            this.image.close();
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Can't release image or close the output stream.");
                }
            }
        }
    }

    public static interface ImageSaverCallback {
        public void onSuccessFinish();

        public void onError();
    }
}

