/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;
import androidx.annotation.RestrictTo;
import com.karumi.dexter.Dexter;
import com.karumi.dexter.MultiplePermissionsReport;
import com.karumi.dexter.PermissionToken;
import com.karumi.dexter.listener.PermissionRequest;
import com.karumi.dexter.listener.multi.MultiplePermissionsListener;
import com.sandrios.sandriosCamera.R;
import com.sandrios.sandriosCamera.internal.ui.SandriosCameraActivity;
import com.sandrios.sandriosCamera.internal.ui.model.Media;
import com.sandrios.sandriosCamera.internal.ui.model.PhotoQualityOption;
import com.sandrios.sandriosCamera.internal.ui.model.VideoQualityOption;
import com.sandrios.sandriosCamera.internal.ui.preview.PreviewActivity;
import com.sandrios.sandriosCamera.internal.ui.view.CameraControlPanel;
import com.sandrios.sandriosCamera.internal.ui.view.CameraSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.FlashSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.MediaActionSwitchView;
import com.sandrios.sandriosCamera.internal.ui.view.RecordButton;
import com.sandrios.sandriosCamera.internal.utils.RecyclerItemClickListener;
import com.sandrios.sandriosCamera.internal.utils.RxCursorIterable;
import com.sandrios.sandriosCamera.internal.utils.SandriosBus;
import com.sandrios.sandriosCamera.internal.utils.Size;
import com.sandrios.sandriosCamera.internal.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class BaseSandriosActivity<CameraId>
extends SandriosCameraActivity<CameraId>
implements RecordButton.RecordButtonListener,
FlashSwitchView.FlashModeSwitchListener,
MediaActionSwitchView.OnMediaActionStateChangeListener,
CameraSwitchView.OnCameraTypeChangeListener,
CameraControlPanel.SettingsClickListener,
RecyclerItemClickListener.OnClickListener {
    public static final int ACTION_CONFIRM = 900;
    public static final int ACTION_RETAKE = 901;
    public static final int ACTION_CANCEL = 902;
    protected static final int REQUEST_PREVIEW_CODE = 1001;
    protected int mediaAction = 102;
    protected int mediaQuality = 14;
    protected int passedMediaQuality = 14;
    protected CharSequence[] videoQualities;
    protected CharSequence[] photoQualities;
    protected boolean enableImageCrop = false;
    protected int videoDuration = -1;
    protected long videoFileSize = -1L;
    protected boolean autoRecord = false;
    protected int minimumVideoDuration = -1;
    protected boolean showPicker = true;
    protected int currentMediaActionState;
    protected int currentCameraType = 1;
    protected int newQuality = -1;
    protected int flashMode = 3;
    private List<Media> mediaList = new ArrayList<Media>();
    private CameraControlPanel cameraControlPanel;
    private AlertDialog settingsDialog;
    private CompositeDisposable compositeDisposable;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.CAMERA");
        permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        if (this.mediaAction != 101) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        Dexter.withActivity((Activity)this).withPermissions(permissions).withListener(new MultiplePermissionsListener(){

            public void onPermissionsChecked(MultiplePermissionsReport report) {
                BaseSandriosActivity.this.fetchMediaList();
            }

            public void onPermissionRationaleShouldBeShown(List<PermissionRequest> permissions, PermissionToken token) {
            }
        }).check();
    }

    @Override
    protected void onProcessBundle(Bundle savedInstanceState) {
        super.onProcessBundle(savedInstanceState);
        this.extractConfiguration(this.getIntent().getExtras());
        this.currentMediaActionState = this.mediaAction == 100 ? 1 : 0;
    }

    @Override
    protected void onCameraControllerReady() {
        super.onCameraControllerReady();
        this.videoQualities = this.getVideoQualityOptions();
        this.photoQualities = this.getPhotoQualityOptions();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.cameraControlPanel.lockControls();
        this.cameraControlPanel.allowRecord(false);
        this.cameraControlPanel.showPicker(this.showPicker);
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.cameraControlPanel.lockControls();
        this.cameraControlPanel.allowRecord(false);
    }

    private void extractConfiguration(Bundle bundle) {
        if (bundle != null) {
            if (bundle.containsKey("com.sandrios.sandriosCamera.media_action")) {
                switch (bundle.getInt("com.sandrios.sandriosCamera.media_action")) {
                    case 101: {
                        this.mediaAction = 101;
                        break;
                    }
                    case 100: {
                        this.mediaAction = 100;
                        break;
                    }
                    default: {
                        this.mediaAction = 102;
                    }
                }
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.camera_media_quality")) {
                switch (bundle.getInt("com.sandrios.sandriosCamera.camera_media_quality")) {
                    case 10: {
                        this.mediaQuality = 10;
                        break;
                    }
                    case 14: {
                        this.mediaQuality = 14;
                        break;
                    }
                    case 13: {
                        this.mediaQuality = 13;
                        break;
                    }
                    case 12: {
                        this.mediaQuality = 12;
                        break;
                    }
                    case 11: {
                        this.mediaQuality = 11;
                        break;
                    }
                    case 15: {
                        this.mediaQuality = 15;
                        break;
                    }
                    default: {
                        this.mediaQuality = 12;
                    }
                }
                this.passedMediaQuality = this.mediaQuality;
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.video_duration")) {
                this.videoDuration = bundle.getInt("com.sandrios.sandriosCamera.video_duration");
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.camera_video_file_size")) {
                this.videoFileSize = bundle.getLong("com.sandrios.sandriosCamera.camera_video_file_size");
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.minimum.video_duration")) {
                this.minimumVideoDuration = bundle.getInt("com.sandrios.sandriosCamera.minimum.video_duration");
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.show_picker")) {
                this.showPicker = bundle.getBoolean("com.sandrios.sandriosCamera.show_picker");
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.enable_crop")) {
                this.enableImageCrop = bundle.getBoolean("com.sandrios.sandriosCamera.enable_crop");
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.camera_flash_mode")) {
                switch (bundle.getInt("com.sandrios.sandriosCamera.camera_flash_mode")) {
                    case 3: {
                        this.flashMode = 3;
                        break;
                    }
                    case 1: {
                        this.flashMode = 1;
                        break;
                    }
                    case 2: {
                        this.flashMode = 2;
                        break;
                    }
                    default: {
                        this.flashMode = 3;
                    }
                }
            }
            if (bundle.containsKey("com.sandrios.sandriosCamera.auto_record") && this.mediaAction == 100) {
                this.autoRecord = bundle.getBoolean("com.sandrios.sandriosCamera.auto_record");
            }
        }
    }

    @Override
    View getUserContentView(LayoutInflater layoutInflater, ViewGroup parent) {
        this.cameraControlPanel = (CameraControlPanel)layoutInflater.inflate(R.layout.user_control_layout, parent, false);
        if (this.cameraControlPanel != null) {
            this.cameraControlPanel.setup(this.getMediaAction());
            switch (this.flashMode) {
                case 3: {
                    this.cameraControlPanel.setFlasMode(2);
                    break;
                }
                case 1: {
                    this.cameraControlPanel.setFlasMode(0);
                    break;
                }
                case 2: {
                    this.cameraControlPanel.setFlasMode(1);
                }
            }
            this.cameraControlPanel.setRecordButtonListener(this);
            this.cameraControlPanel.setFlashModeSwitchListener(this);
            this.cameraControlPanel.setOnMediaActionStateChangeListener(this);
            this.cameraControlPanel.setOnCameraTypeChangeListener(this);
            this.cameraControlPanel.setMaxVideoDuration(this.getVideoDuration());
            this.cameraControlPanel.setMaxVideoFileSize(this.getVideoFileSize());
            this.cameraControlPanel.setSettingsClickListener(this);
            this.cameraControlPanel.setPickerItemClickListener(this);
            this.cameraControlPanel.shouldShowCrop(this.enableImageCrop);
            if (this.autoRecord) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BaseSandriosActivity.this.cameraControlPanel.startRecording();
                    }
                }, 1500L);
            }
        }
        return this.cameraControlPanel;
    }

    @Override
    public void onSettingsClick() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        if (this.currentMediaActionState == 1) {
            builder.setSingleChoiceItems(this.videoQualities, this.getVideoOptionCheckedIndex(), this.getVideoOptionSelectedListener());
            if (this.getVideoFileSize() > 0L) {
                builder.setTitle((CharSequence)String.format(this.getString(R.string.settings_video_quality_title), "(Max " + String.valueOf(this.getVideoFileSize() / 0x100000L + " MB)")));
            } else {
                builder.setTitle((CharSequence)String.format(this.getString(R.string.settings_video_quality_title), ""));
            }
        } else {
            builder.setSingleChoiceItems(this.photoQualities, this.getPhotoOptionCheckedIndex(), this.getPhotoOptionSelectedListener());
            builder.setTitle(R.string.settings_photo_quality_title);
        }
        builder.setPositiveButton(R.string.ok_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (BaseSandriosActivity.this.newQuality > 0 && BaseSandriosActivity.this.newQuality != BaseSandriosActivity.this.mediaQuality) {
                    BaseSandriosActivity.this.mediaQuality = BaseSandriosActivity.this.newQuality;
                    dialogInterface.dismiss();
                    BaseSandriosActivity.this.cameraControlPanel.lockControls();
                    BaseSandriosActivity.this.getCameraController().switchQuality();
                }
            }
        });
        builder.setNegativeButton(R.string.cancel_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        });
        this.settingsDialog = builder.create();
        this.settingsDialog.show();
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.copyFrom(this.settingsDialog.getWindow().getAttributes());
        layoutParams.width = Utils.convertDpToPixel(350);
        layoutParams.height = Utils.convertDpToPixel(350);
        this.settingsDialog.getWindow().setAttributes(layoutParams);
    }

    @Override
    public void onItemClick(View view, int position) {
        String filePath = this.mediaList.get(position).getPath();
        int mimeType = this.getMimeType(filePath);
        SandriosBus.getBus().send(new Media(mimeType, filePath));
        this.finish();
    }

    @Override
    public void onCameraTypeChanged(int cameraType) {
        if (this.currentCameraType == cameraType) {
            return;
        }
        this.currentCameraType = cameraType;
        this.cameraControlPanel.lockControls();
        this.cameraControlPanel.allowRecord(false);
        int cameraFace = cameraType == 0 ? 6 : 7;
        this.getCameraController().switchCamera(cameraFace);
    }

    @Override
    public void onFlashModeChanged(int mode) {
        switch (mode) {
            case 2: {
                this.flashMode = 3;
                this.getCameraController().setFlashMode(3);
                break;
            }
            case 0: {
                this.flashMode = 1;
                this.getCameraController().setFlashMode(1);
                break;
            }
            case 1: {
                this.flashMode = 2;
                this.getCameraController().setFlashMode(2);
            }
        }
    }

    @Override
    public void onMediaActionChanged(int mediaActionState) {
        if (this.currentMediaActionState == mediaActionState) {
            return;
        }
        this.currentMediaActionState = mediaActionState;
    }

    @Override
    public void onTakePhotoButtonPressed() {
        this.getCameraController().takePhoto();
    }

    @Override
    public void onStartRecordingButtonPressed() {
        this.getCameraController().startVideoRecord();
    }

    @Override
    public void onStopRecordingButtonPressed() {
        this.getCameraController().stopVideoRecord();
    }

    @Override
    protected void onScreenRotation(int degrees) {
        this.cameraControlPanel.rotateControls(degrees);
        this.rotateSettingsDialog(degrees);
    }

    @Override
    public int getMediaAction() {
        return this.mediaAction;
    }

    @Override
    public int getMediaQuality() {
        return this.mediaQuality;
    }

    @Override
    public int getVideoDuration() {
        return this.videoDuration;
    }

    @Override
    public long getVideoFileSize() {
        return this.videoFileSize;
    }

    @Override
    public int getFlashMode() {
        return this.flashMode;
    }

    @Override
    public int getMinimumVideoDuration() {
        return this.minimumVideoDuration / 1000;
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public void updateCameraPreview(Size size, View cameraPreview) {
        this.cameraControlPanel.unLockControls();
        this.cameraControlPanel.allowRecord(true);
        this.setCameraPreview(cameraPreview, size);
    }

    @Override
    public void updateUiForMediaAction(int mediaAction) {
    }

    @Override
    public void updateCameraSwitcher(int numberOfCameras) {
        this.cameraControlPanel.allowCameraSwitching(numberOfCameras > 1);
    }

    @Override
    public void onPhotoTaken() {
        this.startPreviewActivity();
    }

    @Override
    public void onVideoRecordStart(int width, int height) {
        this.cameraControlPanel.onStartVideoRecord(this.getCameraController().getOutputFile());
    }

    @Override
    public void onVideoRecordStop() {
        this.cameraControlPanel.allowRecord(false);
        this.cameraControlPanel.onStopVideoRecord();
        this.startPreviewActivity();
    }

    @Override
    public void releaseCameraPreview() {
        this.clearCameraPreview();
    }

    private void startPreviewActivity() {
        Intent intent = PreviewActivity.newIntent((Context)this, this.getMediaAction(), this.getCameraController().getOutputFile().toString(), this.cameraControlPanel.showCrop());
        this.startActivityForResult(intent, 1001);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1 && requestCode == 1001) {
            if (PreviewActivity.isResultConfirm(data)) {
                String path = PreviewActivity.getMediaFilePatch(data);
                int mimeType = this.getMimeType(path);
                SandriosBus.getBus().send(new Media(mimeType, path));
                this.finish();
            } else if (PreviewActivity.isResultCancel(data) || PreviewActivity.isResultRetake(data)) {
                // empty if block
            }
        }
    }

    private int getMimeType(String path) {
        String extension;
        Uri uri = Uri.fromFile((File)new File(path));
        if (uri.getScheme().equals("content")) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(this.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)path);
        }
        String mimeTypeString = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        int mimeType = 0;
        if (mimeTypeString.toLowerCase().contains("video")) {
            mimeType = 1;
        }
        return mimeType;
    }

    private void rotateSettingsDialog(int degrees) {
        if (this.settingsDialog != null && this.settingsDialog.isShowing()) {
            ViewGroup dialogView = (ViewGroup)this.settingsDialog.getWindow().getDecorView();
            for (int i = 0; i < dialogView.getChildCount(); ++i) {
                dialogView.getChildAt(i).setRotation((float)degrees);
            }
        }
    }

    protected abstract CharSequence[] getVideoQualityOptions();

    protected abstract CharSequence[] getPhotoQualityOptions();

    protected int getVideoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 10) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 11) {
            checkedIndex = 3;
        }
        if (this.passedMediaQuality != 10) {
            --checkedIndex;
        }
        return checkedIndex;
    }

    protected int getPhotoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 14) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 15) {
            checkedIndex = 3;
        }
        return checkedIndex;
    }

    protected DialogInterface.OnClickListener getVideoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            @SuppressLint(value={"WrongConstant"})
            public void onClick(DialogInterface dialogInterface, int index) {
                BaseSandriosActivity.this.newQuality = ((VideoQualityOption)BaseSandriosActivity.this.videoQualities[index]).getMediaQuality();
            }
        };
    }

    protected DialogInterface.OnClickListener getPhotoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            @SuppressLint(value={"WrongConstant"})
            public void onClick(DialogInterface dialogInterface, int index) {
                BaseSandriosActivity.this.newQuality = ((PhotoQualityOption)BaseSandriosActivity.this.photoQualities[index]).getMediaQuality();
            }
        };
    }

    private void fetchMediaList() {
        switch (this.mediaAction) {
            case 101: {
                this.addPhotosToList();
                break;
            }
            case 100: {
                this.addVideosToList();
                break;
            }
            case 102: {
                this.addPhotosToList();
                this.addVideosToList();
            }
        }
        this.cameraControlPanel.setMediaList(this.mediaList);
    }

    private void addPhotosToList() {
        String[] columns = new String[]{"_data"};
        String orderBy = "date_added DESC";
        Cursor imageCursor = this.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, orderBy);
        this.addToMediaList(imageCursor, 0);
    }

    private void addVideosToList() {
        String[] columns = new String[]{"_data"};
        String orderBy = "date_added DESC";
        Cursor videoCursor = this.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, columns, null, null, orderBy);
        this.addToMediaList(videoCursor, 1);
    }

    private void addToMediaList(Cursor cursor, final int type) {
        try {
            Disposable d = Observable.fromIterable((Iterable)RxCursorIterable.from(cursor)).doAfterNext((Consumer)new Consumer<Cursor>(){

                public void accept(Cursor cursor) {
                    if (cursor.getPosition() == cursor.getCount() - 1) {
                        cursor.close();
                    }
                }
            }).subscribe((Consumer)new Consumer<Cursor>(){

                public void accept(Cursor cursor) {
                    String imageLocation = cursor.getString(cursor.getColumnIndex("_data"));
                    Media media = new Media();
                    media.setType(type);
                    media.setPath(imageLocation);
                    BaseSandriosActivity.this.mediaList.add(media);
                }
            });
            this.getCompositeDisposable().add(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompositeDisposable getCompositeDisposable() {
        if (this.compositeDisposable == null || this.compositeDisposable.isDisposed()) {
            this.compositeDisposable = new CompositeDisposable();
        }
        return this.compositeDisposable;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.compositeDisposable != null && !this.compositeDisposable.isDisposed()) {
            this.compositeDisposable.dispose();
        }
    }
}

