/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.sandrios.sandriosCamera.internal.ui.camera.Camera1Activity;
import com.sandrios.sandriosCamera.internal.ui.camera2.Camera2Activity;
import com.sandrios.sandriosCamera.internal.ui.model.Media;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import com.sandrios.sandriosCamera.internal.utils.SandriosBus;
import io.reactivex.functions.Consumer;

public class SandriosCamera {
    private static SandriosCamera mInstance = null;
    private static Activity mActivity;
    private int mediaAction = 102;
    private boolean showPicker = true;
    private boolean autoRecord = false;
    private boolean enableImageCrop = false;
    private long videoSize = -1L;

    public static SandriosCamera with(Activity activity) {
        if (mInstance == null) {
            mInstance = new SandriosCamera();
        }
        mActivity = activity;
        return mInstance;
    }

    public SandriosCamera setShowPicker(boolean showPicker) {
        this.showPicker = showPicker;
        return mInstance;
    }

    public SandriosCamera setMediaAction(int mediaAction) {
        this.mediaAction = mediaAction;
        return mInstance;
    }

    public SandriosCamera enableImageCropping(boolean enableImageCrop) {
        this.enableImageCrop = enableImageCrop;
        return mInstance;
    }

    public SandriosCamera setVideoFileSize(int fileSize) {
        this.videoSize = fileSize;
        return mInstance;
    }

    public SandriosCamera setAutoRecord() {
        this.autoRecord = true;
        return mInstance;
    }

    public void launchCamera(final CameraCallback cameraCallback) {
        this.launchIntent();
        SandriosBus.getBus().toObserverable().subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                if (o instanceof Media) {
                    Media outputModel = (Media)o;
                    if (cameraCallback != null) {
                        cameraCallback.onComplete(outputModel);
                        mInstance = null;
                    }
                    SandriosBus.complete();
                }
            }
        });
    }

    private void launchIntent() {
        if (CameraHelper.hasCamera((Context)mActivity)) {
            Intent cameraIntent = CameraHelper.hasCamera2((Context)mActivity) ? new Intent((Context)mActivity, Camera2Activity.class) : new Intent((Context)mActivity, Camera1Activity.class);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.show_picker", this.showPicker);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.media_action", this.mediaAction);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.enable_crop", this.enableImageCrop);
            cameraIntent.putExtra("com.sandrios.sandriosCamera.auto_record", this.autoRecord);
            if (this.videoSize > 0L) {
                cameraIntent.putExtra("com.sandrios.sandriosCamera.camera_video_file_size", this.videoSize * 1024L * 1024L);
            }
            mActivity.startActivity(cameraIntent);
        }
    }

    public class MediaType {
        public static final int PHOTO = 0;
        public static final int VIDEO = 1;
    }

    public static interface CameraCallback {
        public void onComplete(Media var1);
    }
}

