/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.sandrios.sandriosCamera.R;
import java.io.File;
import java.util.ArrayList;

public class ImageGalleryAdapter
extends RecyclerView.Adapter<GalleryViewHolder> {
    ArrayList<PickerTile> pickerTiles;
    Context context;
    OnItemClickListener onItemClickListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageGalleryAdapter(Context context, int type) {
        this.context = context;
        this.pickerTiles = new ArrayList();
        if (type == 501) {
            Cursor videoCursor = null;
            try {
                String[] columns = new String[]{"_data"};
                String orderBy = "date_added DESC";
                videoCursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, columns, null, null, "date_added DESC");
                if (videoCursor == null) return;
                int count = 0;
                while (videoCursor.moveToNext()) {
                    String videoLocation = videoCursor.getString(videoCursor.getColumnIndex("_data"));
                    File videoFile = new File(videoLocation);
                    this.pickerTiles.add(new PickerTile(Uri.fromFile((File)videoFile)));
                    ++count;
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (videoCursor != null && !videoCursor.isClosed()) {
                    videoCursor.close();
                }
            }
        }
        Cursor imageCursor = null;
        try {
            String[] columns = new String[]{"_data", "orientation"};
            String orderBy = "date_added DESC";
            imageCursor = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "date_added DESC");
            if (imageCursor == null) return;
            int count = 0;
            while (imageCursor.moveToNext()) {
                String imageLocation = imageCursor.getString(imageCursor.getColumnIndex("_data"));
                File imageFile = new File(imageLocation);
                this.pickerTiles.add(new PickerTile(Uri.fromFile((File)imageFile)));
                ++count;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (imageCursor != null && !imageCursor.isClosed()) {
                imageCursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageGalleryAdapter(Context context) {
        this.context = context;
        this.pickerTiles = new ArrayList();
        Cursor imageCursor = null;
        try {
            String[] columns = new String[]{"_data", "orientation"};
            String orderBy = "date_added DESC";
            imageCursor = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "date_added DESC");
            if (imageCursor != null) {
                int count = 0;
                while (imageCursor.moveToNext()) {
                    String imageLocation = imageCursor.getString(imageCursor.getColumnIndex("_data"));
                    File imageFile = new File(imageLocation);
                    this.pickerTiles.add(new PickerTile(Uri.fromFile((File)imageFile)));
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (imageCursor != null && !imageCursor.isClosed()) {
                imageCursor.close();
            }
        }
    }

    public GalleryViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = View.inflate((Context)this.context, (int)R.layout.image_item, null);
        return new GalleryViewHolder(view);
    }

    public void onBindViewHolder(final GalleryViewHolder holder, final int position) {
        PickerTile pickerTile = this.getItem(position);
        Uri uri = pickerTile.getImageUri();
        Glide.with((Context)this.context).load(uri).thumbnail(0.1f).dontAnimate().centerCrop().placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_gallery)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_error)).into(holder.iv_thumbnail);
        if (this.onItemClickListener != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImageGalleryAdapter.this.onItemClickListener.onItemClick(holder.itemView, position);
                }
            });
        }
    }

    public int getItemCount() {
        return this.pickerTiles.size();
    }

    public PickerTile getItem(int position) {
        return this.pickerTiles.get(position);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    class GalleryViewHolder
    extends RecyclerView.ViewHolder {
        ImageView iv_thumbnail;

        public GalleryViewHolder(View view) {
            super(view);
            this.iv_thumbnail = (ImageView)view.findViewById(R.id.image);
        }
    }

    public static class PickerTile {
        protected final Uri imageUri;

        PickerTile(@NonNull Uri imageUri) {
            this.imageUri = imageUri;
        }

        @Nullable
        public Uri getImageUri() {
            return this.imageUri;
        }

        public String toString() {
            return "ImageTile: " + this.imageUri;
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

