/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public class AspectFrameLayout
extends FrameLayout {
    private static final String TAG = "AspectFrameLayout";
    private double targetAspectRatio = -1.0;

    public AspectFrameLayout(Context context) {
        super(context);
    }

    public AspectFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.targetAspectRatio != aspectRatio) {
            this.targetAspectRatio = aspectRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.targetAspectRatio > 0.0) {
            int verticalPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizontalPadding) / (double)(initialHeight -= (verticalPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDifference = this.targetAspectRatio / viewAspectRatio - 1.0;
            if (!(Math.abs(aspectDifference) < 0.01)) {
                if (aspectDifference > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.targetAspectRatio);
                } else {
                    initialWidth = (int)((double)initialHeight * this.targetAspectRatio);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizontalPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += verticalPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

