/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.sandrios.sandriosCamera.R;
import com.sandrios.sandriosCamera.internal.configuration.ConfigurationProvider;
import com.sandrios.sandriosCamera.internal.controller.CameraController;
import com.sandrios.sandriosCamera.internal.controller.view.CameraView;
import com.sandrios.sandriosCamera.internal.ui.view.AspectFrameLayout;
import com.sandrios.sandriosCamera.internal.utils.Size;
import com.sandrios.sandriosCamera.internal.utils.Utils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class SandriosCameraActivity<CameraId>
extends Activity
implements ConfigurationProvider,
CameraView,
SensorEventListener {
    protected AspectFrameLayout previewContainer;
    protected ViewGroup userContainer;
    protected int sensorPosition = -1;
    protected int deviceDefaultOrientation;
    private SensorManager sensorManager = null;
    private CameraController<CameraId> cameraController;
    private int degrees = -1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.cameraController = this.createCameraController(this, this);
        this.cameraController.onCreate(savedInstanceState);
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        int defaultOrientation = Utils.getDeviceDefaultOrientation((Context)this);
        if (defaultOrientation == 2) {
            this.deviceDefaultOrientation = 546;
        } else if (defaultOrientation == 1) {
            this.deviceDefaultOrientation = 273;
        }
        View decorView = this.getWindow().getDecorView();
        if (Build.VERSION.SDK_INT > 15) {
            int uiOptions = 1024;
            decorView.setSystemUiVisibility(uiOptions);
        }
        this.setContentView(R.layout.generic_camera_layout);
        this.previewContainer = (AspectFrameLayout)this.findViewById(R.id.previewContainer);
        this.userContainer = (ViewGroup)this.findViewById(R.id.userContainer);
        this.onProcessBundle(savedInstanceState);
        this.setUserContent();
    }

    protected void onProcessBundle(Bundle savedInstanceState) {
    }

    protected void onResume() {
        super.onResume();
        this.cameraController.onResume();
        this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1), 3);
    }

    protected void onPause() {
        super.onPause();
        this.cameraController.onPause();
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cameraController.onDestroy();
    }

    public final CameraController<CameraId> getCameraController() {
        return this.cameraController;
    }

    public abstract CameraController<CameraId> createCameraController(CameraView var1, ConfigurationProvider var2);

    private void setUserContent() {
        this.userContainer.removeAllViews();
        this.userContainer.addView(this.getUserContentView(LayoutInflater.from((Context)this), this.userContainer));
    }

    public final void setCameraPreview(View preview, Size previewSize) {
        this.onCameraControllerReady();
        if (this.previewContainer == null || preview == null) {
            return;
        }
        this.previewContainer.removeAllViews();
        this.previewContainer.addView(preview);
        this.previewContainer.setAspectRatio((double)previewSize.getHeight() / (double)previewSize.getWidth());
    }

    public final void clearCameraPreview() {
        if (this.previewContainer != null) {
            this.previewContainer.removeAllViews();
        }
    }

    abstract View getUserContentView(LayoutInflater var1, ViewGroup var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent sensorEvent) {
        SandriosCameraActivity sandriosCameraActivity = this;
        synchronized (sandriosCameraActivity) {
            if (sensorEvent.sensor.getType() == 1) {
                if (sensorEvent.values[0] < 4.0f && sensorEvent.values[0] > -4.0f) {
                    if (sensorEvent.values[1] > 0.0f) {
                        this.sensorPosition = 90;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 0 : 90;
                    } else if (sensorEvent.values[1] < 0.0f) {
                        this.sensorPosition = 270;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 180 : 270;
                    }
                } else if (sensorEvent.values[1] < 4.0f && sensorEvent.values[1] > -4.0f) {
                    if (sensorEvent.values[0] > 0.0f) {
                        this.sensorPosition = 0;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 90 : 180;
                    } else if (sensorEvent.values[0] < 0.0f) {
                        this.sensorPosition = 180;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 270 : 0;
                    }
                }
                this.onScreenRotation(this.degrees);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public final int getSensorPosition() {
        return this.sensorPosition;
    }

    @Override
    public final int getDegrees() {
        return this.degrees;
    }

    protected abstract void onScreenRotation(int var1);

    protected void onCameraControllerReady() {
    }
}

