/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.manager.impl;

import android.content.Context;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.sandrios.sandriosCamera.internal.configuration.ConfigurationProvider;
import com.sandrios.sandriosCamera.internal.manager.impl.BaseCameraManager;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraCloseListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraOpenListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraPhotoListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraVideoListener;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import com.sandrios.sandriosCamera.internal.utils.Size;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class Camera1Manager
extends BaseCameraManager<Integer, SurfaceHolder.Callback>
implements SurfaceHolder.Callback,
Camera.PictureCallback {
    private static final String TAG = "Camera1Manager";
    private static Camera1Manager currentInstance;
    private Camera camera;
    private Surface surface;
    private int orientation;
    private int displayRotation = 0;
    private boolean safeToTakePicture = false;
    private File outputPath;
    private CameraVideoListener videoListener;
    private CameraPhotoListener photoListener;

    private Camera1Manager() {
    }

    public static Camera1Manager getInstance() {
        if (currentInstance == null) {
            currentInstance = new Camera1Manager();
        }
        return currentInstance;
    }

    @Override
    public void openCamera(final Integer cameraId, final CameraOpenListener<Integer, SurfaceHolder.Callback> cameraOpenListener) {
        this.currentCameraId = cameraId;
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        Camera1Manager.this.camera = Camera.open((int)cameraId);
                        Camera1Manager.this.prepareCameraOutputs();
                        if (cameraOpenListener != null) {
                            Camera1Manager.this.uiHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    cameraOpenListener.onCameraOpened(cameraId, Camera1Manager.this.previewSize, currentInstance);
                                }
                            });
                        }
                    }
                    catch (Exception error) {
                        Log.d((String)Camera1Manager.TAG, (String)("Can't open camera: " + error.getMessage()));
                        if (cameraOpenListener == null) break block3;
                        Camera1Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                cameraOpenListener.onCameraOpenError();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void closeCamera(final CameraCloseListener<Integer> cameraCloseListener) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Camera1Manager.this.camera != null) {
                    Camera1Manager.this.camera.release();
                    Camera1Manager.this.camera = null;
                    if (cameraCloseListener != null) {
                        Camera1Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                cameraCloseListener.onCameraClosed(Camera1Manager.this.currentCameraId);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void takePhoto(File photoFile, CameraPhotoListener cameraPhotoListener) {
        this.outputPath = photoFile;
        this.photoListener = cameraPhotoListener;
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Camera1Manager.this.safeToTakePicture) {
                    Camera1Manager.this.setCameraPhotoQuality(Camera1Manager.this.camera);
                    Camera1Manager.this.camera.takePicture(null, null, (Camera.PictureCallback)currentInstance);
                    Camera1Manager.this.safeToTakePicture = false;
                }
            }
        });
    }

    @Override
    public void startVideoRecord(File videoFile, CameraVideoListener cameraVideoListener) {
        if (this.isVideoRecording) {
            return;
        }
        this.outputPath = videoFile;
        this.videoListener = cameraVideoListener;
        if (this.videoListener != null) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (Camera1Manager.this.prepareVideoRecorder()) {
                        Camera1Manager.this.videoRecorder.start();
                        Camera1Manager.this.isVideoRecording = true;
                        Camera1Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                Camera1Manager.this.videoListener.onVideoRecordStarted(Camera1Manager.this.videoSize);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void stopVideoRecord() {
        if (this.isVideoRecording) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Camera1Manager.this.videoRecorder != null) {
                            Camera1Manager.this.videoRecorder.stop();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Camera1Manager.this.isVideoRecording = false;
                    Camera1Manager.this.releaseVideoRecorder();
                    if (Camera1Manager.this.videoListener != null) {
                        Camera1Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                Camera1Manager.this.videoListener.onVideoRecordStopped(Camera1Manager.this.outputPath);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void releaseCameraManager() {
        super.releaseCameraManager();
    }

    @Override
    public void initializeCameraManager(ConfigurationProvider configurationProvider, Context context) {
        super.initializeCameraManager(configurationProvider, context);
        this.numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < this.numberOfCameras; ++i) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 0) {
                this.faceBackCameraId = i;
                this.faceBackCameraOrientation = cameraInfo.orientation;
                continue;
            }
            if (cameraInfo.facing != 1) continue;
            this.faceFrontCameraId = i;
            this.faceFrontCameraOrientation = cameraInfo.orientation;
        }
    }

    @Override
    public Size getPhotoSizeForQuality(int mediaQuality) {
        return CameraHelper.getPictureSize(Size.fromList(this.camera.getParameters().getSupportedPictureSizes()), mediaQuality);
    }

    @Override
    public void setFlashMode(int flashMode) {
        this.setFlashMode(this.camera, this.camera.getParameters(), flashMode);
    }

    @Override
    protected void prepareCameraOutputs() {
        try {
            this.camcorderProfile = this.configurationProvider.getMediaQuality() == 10 ? CameraHelper.getCamcorderProfile((Integer)this.currentCameraId, this.configurationProvider.getVideoFileSize(), this.configurationProvider.getMinimumVideoDuration()) : CameraHelper.getCamcorderProfile(this.configurationProvider.getMediaQuality(), (Integer)this.currentCameraId);
            List<Size> previewSizes = Size.fromList(this.camera.getParameters().getSupportedPreviewSizes());
            List<Size> pictureSizes = Size.fromList(this.camera.getParameters().getSupportedPictureSizes());
            List<Size> videoSizes = Size.fromList(this.camera.getParameters().getSupportedVideoSizes());
            this.videoSize = CameraHelper.getSizeWithClosestRatio(videoSizes == null || videoSizes.isEmpty() ? previewSizes : videoSizes, this.camcorderProfile.videoFrameWidth, this.camcorderProfile.videoFrameHeight);
            this.photoSize = CameraHelper.getPictureSize(pictureSizes == null || pictureSizes.isEmpty() ? previewSizes : pictureSizes, this.configurationProvider.getMediaQuality() == 10 ? 14 : this.configurationProvider.getMediaQuality());
            this.previewSize = this.configurationProvider.getMediaAction() == 101 || this.configurationProvider.getMediaAction() == 102 ? CameraHelper.getSizeWithClosestRatio(previewSizes, this.photoSize.getWidth(), this.photoSize.getHeight()) : CameraHelper.getSizeWithClosestRatio(previewSizes, this.videoSize.getWidth(), this.videoSize.getHeight());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while setup camera sizes.");
        }
    }

    @Override
    protected boolean prepareVideoRecorder() {
        this.videoRecorder = new MediaRecorder();
        try {
            this.camera.lock();
            this.camera.unlock();
            this.videoRecorder.setCamera(this.camera);
            this.videoRecorder.setAudioSource(0);
            this.videoRecorder.setVideoSource(0);
            this.videoRecorder.setOutputFormat(this.camcorderProfile.fileFormat);
            this.videoRecorder.setVideoFrameRate(this.camcorderProfile.videoFrameRate);
            this.videoRecorder.setVideoSize(this.videoSize.getWidth(), this.videoSize.getHeight());
            this.videoRecorder.setVideoEncodingBitRate(this.camcorderProfile.videoBitRate);
            this.videoRecorder.setVideoEncoder(this.camcorderProfile.videoCodec);
            this.videoRecorder.setAudioEncodingBitRate(this.camcorderProfile.audioBitRate);
            this.videoRecorder.setAudioChannels(this.camcorderProfile.audioChannels);
            this.videoRecorder.setAudioSamplingRate(this.camcorderProfile.audioSampleRate);
            this.videoRecorder.setAudioEncoder(this.camcorderProfile.audioCodec);
            this.videoRecorder.setOutputFile(this.outputPath.toString());
            if (this.configurationProvider.getVideoFileSize() > 0L) {
                this.videoRecorder.setMaxFileSize(this.configurationProvider.getVideoFileSize());
                this.videoRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
            }
            if (this.configurationProvider.getVideoDuration() > 0) {
                this.videoRecorder.setMaxDuration(this.configurationProvider.getVideoDuration());
                this.videoRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
            }
            this.videoRecorder.setOrientationHint(this.getVideoOrientation(this.configurationProvider.getSensorPosition()));
            this.videoRecorder.setPreviewDisplay(this.surface);
            this.videoRecorder.prepare();
            return true;
        }
        catch (IllegalStateException error) {
            Log.e((String)TAG, (String)("IllegalStateException preparing MediaRecorder: " + error.getMessage()));
        }
        catch (IOException error) {
            Log.e((String)TAG, (String)("IOException preparing MediaRecorder: " + error.getMessage()));
        }
        catch (Throwable error) {
            Log.e((String)TAG, (String)("Error during preparing MediaRecorder: " + error.getMessage()));
        }
        this.releaseVideoRecorder();
        return false;
    }

    @Override
    protected void onMaxDurationReached() {
        this.stopVideoRecord();
    }

    @Override
    protected void onMaxFileSizeReached() {
        this.stopVideoRecord();
    }

    @Override
    protected void releaseVideoRecorder() {
        super.releaseVideoRecorder();
        try {
            this.camera.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPreview(SurfaceHolder surfaceHolder) {
        try {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)((Integer)this.currentCameraId), (Camera.CameraInfo)cameraInfo);
            int cameraRotationOffset = cameraInfo.orientation;
            Camera.Parameters parameters = this.camera.getParameters();
            this.setAutoFocus(this.camera, parameters);
            this.setFlashMode(this.configurationProvider.getFlashMode());
            if (this.configurationProvider.getMediaAction() == 101 || this.configurationProvider.getMediaAction() == 102) {
                this.turnPhotoCameraFeaturesOn(this.camera, parameters);
            } else if (this.configurationProvider.getMediaAction() == 101 || this.configurationProvider.getMediaAction() == 102) {
                this.turnVideoCameraFeaturesOn(this.camera, parameters);
            }
            int rotation = ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay().getRotation();
            int degrees = 0;
            switch (rotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                }
            }
            if (cameraInfo.facing == 1) {
                this.displayRotation = (cameraRotationOffset + degrees) % 360;
                this.displayRotation = (360 - this.displayRotation) % 360;
            } else {
                this.displayRotation = (cameraRotationOffset - degrees + 360) % 360;
            }
            this.camera.setDisplayOrientation(this.displayRotation);
            if (Build.VERSION.SDK_INT > 14 && parameters.isVideoStabilizationSupported() && (this.configurationProvider.getMediaAction() == 100 || this.configurationProvider.getMediaAction() == 102)) {
                parameters.setVideoStabilization(true);
            }
            parameters.setPreviewSize(this.previewSize.getWidth(), this.previewSize.getHeight());
            parameters.setPictureSize(this.photoSize.getWidth(), this.photoSize.getHeight());
            this.camera.setParameters(parameters);
            this.camera.setPreviewDisplay(surfaceHolder);
            this.camera.startPreview();
            this.safeToTakePicture = true;
        }
        catch (IOException error) {
            Log.d((String)TAG, (String)("Error setting camera preview: " + error.getMessage()));
        }
        catch (Exception ignore) {
            Log.d((String)TAG, (String)("Error starting camera preview: " + ignore.getMessage()));
        }
    }

    private void turnPhotoCameraFeaturesOn(Camera camera, Camera.Parameters parameters) {
        if (parameters.getSupportedFocusModes().contains("continuous-picture")) {
            parameters.setFocusMode("continuous-picture");
        }
        camera.setParameters(parameters);
    }

    private void turnVideoCameraFeaturesOn(Camera camera, Camera.Parameters parameters) {
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private void setAutoFocus(Camera camera, Camera.Parameters parameters) {
        try {
            if (parameters.getSupportedFocusModes().contains("auto")) {
                parameters.setFocusMode("auto");
                camera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFlashMode(Camera camera, Camera.Parameters parameters, int flashMode) {
        try {
            switch (flashMode) {
                case 3: {
                    parameters.setFlashMode("auto");
                    break;
                }
                case 1: {
                    parameters.setFlashMode("on");
                    break;
                }
                case 2: {
                    parameters.setFlashMode("off");
                    break;
                }
                default: {
                    parameters.setFlashMode("auto");
                }
            }
            camera.setParameters(parameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCameraPhotoQuality(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPictureFormat(256);
        if (this.configurationProvider.getMediaQuality() == 11) {
            parameters.setJpegQuality(50);
        } else if (this.configurationProvider.getMediaQuality() == 12) {
            parameters.setJpegQuality(75);
        } else if (this.configurationProvider.getMediaQuality() == 13) {
            parameters.setJpegQuality(100);
        } else if (this.configurationProvider.getMediaQuality() == 14) {
            parameters.setJpegQuality(100);
        }
        parameters.setPictureSize(this.photoSize.getWidth(), this.photoSize.getHeight());
        camera.setParameters(parameters);
    }

    @Override
    protected int getPhotoOrientation(int sensorPosition) {
        int rotate = ((Integer)this.currentCameraId).equals(this.faceFrontCameraId) ? (360 + this.faceFrontCameraOrientation + this.configurationProvider.getDegrees()) % 360 : (360 + this.faceBackCameraOrientation - this.configurationProvider.getDegrees()) % 360;
        if (rotate == 0) {
            this.orientation = 1;
        } else if (rotate == 90) {
            this.orientation = 6;
        } else if (rotate == 180) {
            this.orientation = 3;
        } else if (rotate == 270) {
            this.orientation = 8;
        }
        return this.orientation;
    }

    @Override
    protected int getVideoOrientation(int sensorPosition) {
        int degrees = 0;
        switch (sensorPosition) {
            case 90: {
                degrees = 0;
                break;
            }
            case 0: {
                degrees = 90;
                break;
            }
            case 270: {
                degrees = 180;
                break;
            }
            case 180: {
                degrees = 270;
                break;
            }
            case -1: {
                degrees = 0;
            }
        }
        int rotate = ((Integer)this.currentCameraId).equals(this.faceFrontCameraId) ? (360 + this.faceFrontCameraOrientation + degrees) % 360 : (360 + this.faceBackCameraOrientation - degrees) % 360;
        return rotate;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.surface = surfaceHolder.getSurface();
        try {
            this.camera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startPreview(surfaceHolder);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.surface = surfaceHolder.getSurface();
        try {
            this.camera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startPreview(surfaceHolder);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void onPictureTaken(byte[] bytes, Camera camera) {
        File pictureFile = this.outputPath;
        if (pictureFile == null) {
            Log.d((String)TAG, (String)"Error creating media file, check storage permissions.");
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(pictureFile);
            fileOutputStream.write(bytes);
            fileOutputStream.close();
        }
        catch (FileNotFoundException error) {
            Log.e((String)TAG, (String)("File not found: " + error.getMessage()));
        }
        catch (IOException error) {
            Log.e((String)TAG, (String)("Error accessing file: " + error.getMessage()));
        }
        catch (Throwable error) {
            Log.e((String)TAG, (String)("Error saving file: " + error.getMessage()));
        }
        try {
            ExifInterface exif = new ExifInterface(pictureFile.getAbsolutePath());
            exif.setAttribute("Orientation", "" + this.getPhotoOrientation(this.configurationProvider.getSensorPosition()));
            exif.saveAttributes();
            if (this.photoListener != null) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Camera1Manager.this.photoListener.onPhotoTaken(Camera1Manager.this.outputPath);
                    }
                });
            }
        }
        catch (Throwable error) {
            Log.e((String)TAG, (String)("Can't save exif info: " + error.getMessage()));
        }
    }
}

