/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.controller.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import com.sandrios.sandriosCamera.internal.configuration.ConfigurationProvider;
import com.sandrios.sandriosCamera.internal.controller.CameraController;
import com.sandrios.sandriosCamera.internal.controller.view.CameraView;
import com.sandrios.sandriosCamera.internal.manager.CameraManager;
import com.sandrios.sandriosCamera.internal.manager.impl.Camera1Manager;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraCloseListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraOpenListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraPhotoListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraVideoListener;
import com.sandrios.sandriosCamera.internal.ui.view.AutoFitSurfaceView;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import com.sandrios.sandriosCamera.internal.utils.Size;
import java.io.File;

@TargetApi(value=24)
public class Camera2ControllerAPI24
implements CameraController<String>,
CameraOpenListener<Integer, SurfaceHolder.Callback>,
CameraPhotoListener,
CameraVideoListener,
CameraCloseListener<Integer> {
    private static final String TAG = "Camera2Controller";
    private String currentCameraId;
    private ConfigurationProvider configurationProvider;
    private CameraManager<Integer, SurfaceHolder.Callback> camera2Manager;
    private CameraView cameraView;
    private File outputFile;

    public Camera2ControllerAPI24(CameraView cameraView, ConfigurationProvider configurationProvider) {
        this.cameraView = cameraView;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.camera2Manager = Camera1Manager.getInstance();
        this.camera2Manager.initializeCameraManager(this.configurationProvider, (Context)this.cameraView.getActivity());
        this.currentCameraId = String.valueOf(this.camera2Manager.getFaceBackCameraId());
    }

    @Override
    public void onResume() {
        this.camera2Manager.openCamera(Integer.valueOf(this.currentCameraId), this);
    }

    @Override
    public void onPause() {
        this.camera2Manager.closeCamera(null);
        this.cameraView.releaseCameraPreview();
    }

    @Override
    public void onDestroy() {
        this.camera2Manager.releaseCameraManager();
    }

    @Override
    public void takePhoto() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 101);
        this.camera2Manager.takePhoto(this.outputFile, this);
    }

    @Override
    public void startVideoRecord() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 100);
        this.camera2Manager.startVideoRecord(this.outputFile, this);
    }

    @Override
    public void stopVideoRecord() {
        this.camera2Manager.stopVideoRecord();
    }

    @Override
    public boolean isVideoRecording() {
        return this.camera2Manager.isVideoRecording();
    }

    @Override
    public void switchCamera(int cameraFace) {
        this.currentCameraId = String.valueOf(this.camera2Manager.getCurrentCameraId().equals(this.camera2Manager.getFaceFrontCameraId()) ? this.camera2Manager.getFaceBackCameraId() : this.camera2Manager.getFaceFrontCameraId());
        this.camera2Manager.closeCamera(this);
    }

    @Override
    public void setFlashMode(int flashMode) {
        this.camera2Manager.setFlashMode(flashMode);
    }

    @Override
    public void switchQuality() {
        this.camera2Manager.closeCamera(this);
    }

    @Override
    public int getNumberOfCameras() {
        return this.camera2Manager.getNumberOfCameras();
    }

    @Override
    public int getMediaAction() {
        return this.configurationProvider.getMediaAction();
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public String getCurrentCameraId() {
        return this.currentCameraId;
    }

    @Override
    public void onCameraOpened(Integer openedCameraId, Size previewSize, SurfaceHolder.Callback surfaceTextureListener) {
        this.cameraView.updateUiForMediaAction(102);
        this.cameraView.updateCameraPreview(previewSize, (View)new AutoFitSurfaceView((Context)this.cameraView.getActivity(), surfaceTextureListener));
        this.cameraView.updateCameraSwitcher(this.camera2Manager.getNumberOfCameras());
    }

    @Override
    public void onCameraOpenError() {
        Log.e((String)TAG, (String)"onCameraOpenError");
    }

    @Override
    public void onCameraClosed(Integer closedCameraId) {
        this.cameraView.releaseCameraPreview();
        this.camera2Manager.openCamera(Integer.valueOf(this.currentCameraId), this);
    }

    @Override
    public void onPhotoTaken(File photoFile) {
        this.cameraView.onPhotoTaken();
    }

    @Override
    public void onPhotoTakeError() {
    }

    @Override
    public void onVideoRecordStarted(Size videoSize) {
        this.cameraView.onVideoRecordStart(videoSize.getWidth(), videoSize.getHeight());
    }

    @Override
    public void onVideoRecordStopped(File videoFile) {
        this.cameraView.onVideoRecordStop();
    }

    @Override
    public void onVideoRecordError() {
    }

    @Override
    public CameraManager getCameraManager() {
        return this.camera2Manager;
    }
}

