/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;

public class Utils {
    public static int getDeviceDefaultOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Configuration config = context.getResources().getConfiguration();
        int rotation = windowManager.getDefaultDisplay().getRotation();
        if ((rotation == 0 || rotation == 2) && config.orientation == 2 || (rotation == 1 || rotation == 3) && config.orientation == 1) {
            return 2;
        }
        return 1;
    }

    public static String getMimeType(String url) {
        String type = "";
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        } else {
            String reCheckExtension = MimeTypeMap.getFileExtensionFromUrl((String)url.replaceAll("\\s+", ""));
            if (!TextUtils.isEmpty((CharSequence)reCheckExtension)) {
                type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(reCheckExtension);
            }
        }
        return type;
    }

    public static int convertDipToPixels(Context context, int dip) {
        Resources resources = context.getResources();
        float px = TypedValue.applyDimension((int)1, (float)dip, (DisplayMetrics)resources.getDisplayMetrics());
        return (int)px;
    }
}

