/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.manager.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.media.MediaRecorder;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.TextureView;
import android.view.WindowManager;
import com.sandrios.sandriosCamera.internal.configuration.ConfigurationProvider;
import com.sandrios.sandriosCamera.internal.manager.impl.BaseCameraManager;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraCloseListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraOpenListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraPhotoListener;
import com.sandrios.sandriosCamera.internal.manager.listener.CameraVideoListener;
import com.sandrios.sandriosCamera.internal.utils.CameraHelper;
import com.sandrios.sandriosCamera.internal.utils.ImageSaver;
import com.sandrios.sandriosCamera.internal.utils.Size;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

@TargetApi(value=21)
public final class Camera2Manager
extends BaseCameraManager<String, TextureView.SurfaceTextureListener>
implements ImageReader.OnImageAvailableListener,
TextureView.SurfaceTextureListener {
    private static final String TAG = "Camera2Manager";
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRE_CAPTURE = 2;
    private static final int STATE_WAITING_NON_PRE_CAPTURE = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private static Camera2Manager currentInstance;
    private CameraOpenListener<String, TextureView.SurfaceTextureListener> cameraOpenListener;
    private CameraPhotoListener cameraPhotoListener;
    private CameraVideoListener cameraVideoListener;
    private File outputPath;
    private int previewState = 0;
    private CameraManager manager;
    private CameraDevice cameraDevice;
    private CaptureRequest previewRequest;
    private CaptureRequest.Builder previewRequestBuilder;
    private CameraCaptureSession captureSession;
    private CameraCharacteristics frontCameraCharacteristics;
    private CameraCharacteristics backCameraCharacteristics;
    private StreamConfigurationMap frontCameraStreamConfigurationMap;
    private StreamConfigurationMap backCameraStreamConfigurationMap;
    private SurfaceTexture texture;
    private Surface workingSurface;
    private ImageReader imageReader;
    private CameraDevice.StateCallback stateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            currentInstance.cameraDevice = cameraDevice;
            if (Camera2Manager.this.cameraOpenListener != null) {
                Camera2Manager.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextUtils.isEmpty((CharSequence)((CharSequence)Camera2Manager.this.currentCameraId)) && Camera2Manager.this.previewSize != null && currentInstance != null) {
                            Camera2Manager.this.cameraOpenListener.onCameraOpened(Camera2Manager.this.currentCameraId, Camera2Manager.this.previewSize, currentInstance);
                        }
                    }
                });
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            currentInstance.cameraDevice = null;
            Camera2Manager.this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2Manager.this.cameraOpenListener.onCameraOpenError();
                }
            });
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            currentInstance.cameraDevice = null;
            Camera2Manager.this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2Manager.this.cameraOpenListener.onCameraOpenError();
                }
            });
        }
    };
    private CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            Camera2Manager.this.processCaptureResult(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Camera2Manager.this.processCaptureResult((CaptureResult)result);
        }
    };

    private Camera2Manager() {
    }

    public static Camera2Manager getInstance() {
        if (currentInstance == null) {
            currentInstance = new Camera2Manager();
        }
        return currentInstance;
    }

    @Override
    public void initializeCameraManager(ConfigurationProvider configurationProvider, Context context) {
        super.initializeCameraManager(configurationProvider, context);
        this.manager = (CameraManager)context.getSystemService("camera");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        this.windowSize = new Size(size.x, size.y);
        try {
            String[] ids = this.manager.getCameraIdList();
            this.numberOfCameras = ids.length;
            for (String id : ids) {
                CameraCharacteristics characteristics = this.manager.getCameraCharacteristics(id);
                int orientation = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (orientation == 0) {
                    this.faceFrontCameraId = id;
                    this.faceFrontCameraOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                    this.frontCameraCharacteristics = characteristics;
                    continue;
                }
                this.faceBackCameraId = id;
                this.faceBackCameraOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                this.backCameraCharacteristics = characteristics;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error during camera init");
        }
    }

    @Override
    public void openCamera(String cameraId, final CameraOpenListener<String, TextureView.SurfaceTextureListener> cameraOpenListener) {
        this.currentCameraId = cameraId;
        this.cameraOpenListener = cameraOpenListener;
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (Camera2Manager.this.context == null || Camera2Manager.this.configurationProvider == null) {
                        if (cameraOpenListener != null) {
                            Camera2Manager.this.uiHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    cameraOpenListener.onCameraOpenError();
                                }
                            });
                        }
                        return;
                    }
                    Camera2Manager.this.prepareCameraOutputs();
                    try {
                        Camera2Manager.this.manager.openCamera((String)Camera2Manager.this.currentCameraId, Camera2Manager.this.stateCallback, Camera2Manager.this.backgroundHandler);
                    }
                    catch (Exception e) {
                        if (cameraOpenListener == null) break block4;
                        Camera2Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                cameraOpenListener.onCameraOpenError();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void closeCamera(final CameraCloseListener<String> cameraCloseListener) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                Camera2Manager.this.closeCamera();
                if (cameraCloseListener != null) {
                    Camera2Manager.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            cameraCloseListener.onCameraClosed(Camera2Manager.this.currentCameraId);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setFlashMode(int flashMode) {
        this.setFlashModeAndBuildPreviewRequest(flashMode);
    }

    @Override
    public void takePhoto(File photoFile, CameraPhotoListener cameraPhotoListener) {
        this.outputPath = photoFile;
        this.cameraPhotoListener = cameraPhotoListener;
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                Camera2Manager.this.lockFocus();
            }
        });
    }

    @Override
    public Size getPhotoSizeForQuality(int mediaQuality) {
        StreamConfigurationMap map = ((String)this.currentCameraId).equals(this.faceBackCameraId) ? this.backCameraStreamConfigurationMap : this.frontCameraStreamConfigurationMap;
        return CameraHelper.getPictureSize(Size.fromArray2(map.getOutputSizes(256)), mediaQuality);
    }

    @Override
    public void startVideoRecord(File videoFile, final CameraVideoListener cameraVideoListener) {
        if (this.isVideoRecording || this.texture == null) {
            return;
        }
        this.outputPath = videoFile;
        this.cameraVideoListener = cameraVideoListener;
        if (cameraVideoListener != null) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2Manager.this.closePreviewSession();
                    if (Camera2Manager.this.prepareVideoRecorder()) {
                        SurfaceTexture texture = currentInstance.texture;
                        texture.setDefaultBufferSize(Camera2Manager.this.videoSize.getWidth(), Camera2Manager.this.videoSize.getHeight());
                        try {
                            Camera2Manager.this.previewRequestBuilder = Camera2Manager.this.cameraDevice.createCaptureRequest(3);
                            ArrayList<Surface> surfaces = new ArrayList<Surface>();
                            Surface previewSurface = Camera2Manager.this.workingSurface;
                            surfaces.add(previewSurface);
                            Camera2Manager.this.previewRequestBuilder.addTarget(previewSurface);
                            Camera2Manager.this.workingSurface = Camera2Manager.this.videoRecorder.getSurface();
                            surfaces.add(Camera2Manager.this.workingSurface);
                            Camera2Manager.this.previewRequestBuilder.addTarget(Camera2Manager.this.workingSurface);
                            Camera2Manager.this.cameraDevice.createCaptureSession(surfaces, new CameraCaptureSession.StateCallback(){

                                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                                    Camera2Manager.this.captureSession = cameraCaptureSession;
                                    Camera2Manager.this.previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
                                    try {
                                        Camera2Manager.this.captureSession.setRepeatingRequest(Camera2Manager.this.previewRequestBuilder.build(), null, Camera2Manager.this.backgroundHandler);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        Camera2Manager.this.videoRecorder.start();
                                    }
                                    catch (Exception ignore) {
                                        Log.e((String)Camera2Manager.TAG, (String)"videoRecorder.start(): ", (Throwable)ignore);
                                    }
                                    Camera2Manager.this.isVideoRecording = true;
                                    Camera2Manager.this.uiHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            cameraVideoListener.onVideoRecordStarted(Camera2Manager.this.videoSize);
                                        }
                                    });
                                }

                                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                                    Log.d((String)Camera2Manager.TAG, (String)"onConfigureFailed");
                                }
                            }, Camera2Manager.this.backgroundHandler);
                        }
                        catch (Exception e) {
                            Log.e((String)Camera2Manager.TAG, (String)"startVideoRecord: ", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void stopVideoRecord() {
        if (this.isVideoRecording) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2Manager.this.closePreviewSession();
                    if (Camera2Manager.this.videoRecorder != null) {
                        try {
                            Camera2Manager.this.videoRecorder.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Camera2Manager.this.isVideoRecording = false;
                    Camera2Manager.this.releaseVideoRecorder();
                    if (Camera2Manager.this.cameraVideoListener != null) {
                        Camera2Manager.this.uiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                Camera2Manager.this.cameraVideoListener.onVideoRecordStopped(Camera2Manager.this.outputPath);
                            }
                        });
                    }
                }
            });
        }
    }

    private void startPreview(SurfaceTexture texture) {
        try {
            if (texture == null) {
                return;
            }
            this.texture = texture;
            texture.setDefaultBufferSize(this.previewSize.getWidth(), this.previewSize.getHeight());
            this.workingSurface = new Surface(texture);
            this.previewRequestBuilder = this.cameraDevice.createCaptureRequest(1);
            this.previewRequestBuilder.addTarget(this.workingSurface);
            this.cameraDevice.createCaptureSession(Arrays.asList(this.workingSurface, this.imageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2Manager.this.updatePreview(cameraCaptureSession);
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Log.d((String)Camera2Manager.TAG, (String)"Fail while starting preview: ");
                }
            }, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while preparing surface for preview: ", (Throwable)e);
        }
    }

    @Override
    protected void onMaxDurationReached() {
        this.stopVideoRecord();
    }

    @Override
    protected void onMaxFileSizeReached() {
        this.stopVideoRecord();
    }

    @Override
    protected int getPhotoOrientation(int sensorPosition) {
        return this.getVideoOrientation(sensorPosition);
    }

    @Override
    protected int getVideoOrientation(int sensorPosition) {
        int degrees = 0;
        switch (sensorPosition) {
            case 90: {
                degrees = 0;
                break;
            }
            case 0: {
                degrees = 90;
                break;
            }
            case 270: {
                degrees = 180;
                break;
            }
            case 180: {
                degrees = 270;
                break;
            }
        }
        int rotate = Objects.equals(this.currentCameraId, this.faceFrontCameraId) ? (360 + this.faceFrontCameraOrientation + degrees) % 360 : (360 + this.faceBackCameraOrientation - degrees) % 360;
        return rotate;
    }

    private void closeCamera() {
        this.closePreviewSession();
        this.releaseTexture();
        this.closeCameraDevice();
        this.closeImageReader();
        this.releaseVideoRecorder();
    }

    private void releaseTexture() {
        if (null != this.texture) {
            this.texture.release();
            this.texture = null;
        }
    }

    private void closeImageReader() {
        if (null != this.imageReader) {
            this.imageReader.close();
            this.imageReader = null;
        }
    }

    private void closeCameraDevice() {
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
    }

    @Override
    protected void prepareCameraOutputs() {
        try {
            CameraCharacteristics characteristics;
            CameraCharacteristics cameraCharacteristics = characteristics = ((String)this.currentCameraId).equals(this.faceBackCameraId) ? this.backCameraCharacteristics : this.frontCameraCharacteristics;
            if (((String)this.currentCameraId).equals(this.faceFrontCameraId) && this.frontCameraStreamConfigurationMap == null) {
                this.frontCameraStreamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            } else if (((String)this.currentCameraId).equals(this.faceBackCameraId) && this.backCameraStreamConfigurationMap == null) {
                this.backCameraStreamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            }
            StreamConfigurationMap map = ((String)this.currentCameraId).equals(this.faceBackCameraId) ? this.backCameraStreamConfigurationMap : this.frontCameraStreamConfigurationMap;
            this.camcorderProfile = this.configurationProvider.getMediaQuality() == 10 ? CameraHelper.getCamcorderProfile((String)this.currentCameraId, this.configurationProvider.getVideoFileSize(), this.configurationProvider.getMinimumVideoDuration()) : CameraHelper.getCamcorderProfile(this.configurationProvider.getMediaQuality(), (String)this.currentCameraId);
            this.videoSize = CameraHelper.chooseOptimalSize(Size.fromArray2(map.getOutputSizes(MediaRecorder.class)), this.windowSize.getWidth(), this.windowSize.getHeight(), new Size(this.camcorderProfile.videoFrameWidth, this.camcorderProfile.videoFrameHeight));
            if (this.videoSize == null || this.videoSize.getWidth() > this.camcorderProfile.videoFrameWidth || this.videoSize.getHeight() > this.camcorderProfile.videoFrameHeight) {
                this.videoSize = CameraHelper.getSizeWithClosestRatio(Size.fromArray2(map.getOutputSizes(MediaRecorder.class)), this.camcorderProfile.videoFrameWidth, this.camcorderProfile.videoFrameHeight);
            } else if (this.videoSize == null || this.videoSize.getWidth() > this.camcorderProfile.videoFrameWidth || this.videoSize.getHeight() > this.camcorderProfile.videoFrameHeight) {
                this.videoSize = CameraHelper.getSizeWithClosestRatio(Size.fromArray2(map.getOutputSizes(MediaRecorder.class)), this.camcorderProfile.videoFrameWidth, this.camcorderProfile.videoFrameHeight);
            }
            this.photoSize = CameraHelper.getPictureSize(Size.fromArray2(map.getOutputSizes(256)), this.configurationProvider.getMediaQuality() == 10 ? 14 : this.configurationProvider.getMediaQuality());
            this.imageReader = ImageReader.newInstance((int)this.photoSize.getWidth(), (int)this.photoSize.getHeight(), (int)256, (int)2);
            this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.backgroundHandler);
            if (this.configurationProvider.getMediaAction() == 101 || this.configurationProvider.getMediaAction() == 102) {
                this.previewSize = this.windowSize.getHeight() * this.windowSize.getWidth() > this.photoSize.getWidth() * this.photoSize.getHeight() ? CameraHelper.getOptimalPreviewSize(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.photoSize.getWidth(), this.photoSize.getHeight()) : CameraHelper.getOptimalPreviewSize(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.windowSize.getWidth(), this.windowSize.getHeight());
                if (this.previewSize == null) {
                    this.previewSize = CameraHelper.chooseOptimalSize(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.windowSize.getWidth(), this.windowSize.getHeight(), this.photoSize);
                }
            } else {
                this.previewSize = this.windowSize.getHeight() * this.windowSize.getWidth() > this.videoSize.getWidth() * this.videoSize.getHeight() ? CameraHelper.getOptimalPreviewSize(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.videoSize.getWidth(), this.videoSize.getHeight()) : CameraHelper.getOptimalPreviewSize(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.windowSize.getWidth(), this.windowSize.getHeight());
                if (this.previewSize == null) {
                    this.previewSize = CameraHelper.getSizeWithClosestRatio(Size.fromArray2(map.getOutputSizes(SurfaceTexture.class)), this.videoSize.getWidth(), this.videoSize.getHeight());
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error while setup camera sizes.", (Throwable)e);
        }
    }

    @Override
    protected boolean prepareVideoRecorder() {
        this.videoRecorder = new MediaRecorder();
        try {
            this.videoRecorder.setAudioSource(5);
            this.videoRecorder.setVideoSource(2);
            this.videoRecorder.setOutputFormat(this.camcorderProfile.fileFormat);
            this.videoRecorder.setVideoFrameRate(this.camcorderProfile.videoFrameRate);
            this.videoRecorder.setVideoSize(this.videoSize.getWidth(), this.videoSize.getHeight());
            this.videoRecorder.setVideoEncodingBitRate(this.camcorderProfile.videoBitRate);
            this.videoRecorder.setVideoEncoder(this.camcorderProfile.videoCodec);
            this.videoRecorder.setAudioEncodingBitRate(this.camcorderProfile.audioBitRate);
            this.videoRecorder.setAudioChannels(this.camcorderProfile.audioChannels);
            this.videoRecorder.setAudioSamplingRate(this.camcorderProfile.audioSampleRate);
            this.videoRecorder.setAudioEncoder(this.camcorderProfile.audioCodec);
            File outputFile = this.outputPath;
            String outputFilePath = outputFile.toString();
            this.videoRecorder.setOutputFile(outputFilePath);
            if (this.configurationProvider.getVideoFileSize() > 0L) {
                this.videoRecorder.setMaxFileSize(this.configurationProvider.getVideoFileSize());
                this.videoRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
            }
            if (this.configurationProvider.getVideoDuration() > 0) {
                this.videoRecorder.setMaxDuration(this.configurationProvider.getVideoDuration());
                this.videoRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
            }
            this.videoRecorder.setOrientationHint(this.getVideoOrientation(this.configurationProvider.getSensorPosition()));
            this.videoRecorder.prepare();
            return true;
        }
        catch (IllegalStateException error) {
            Log.e((String)TAG, (String)("IllegalStateException preparing MediaRecorder: " + error.getMessage()));
        }
        catch (IOException error) {
            Log.e((String)TAG, (String)("IOException preparing MediaRecorder: " + error.getMessage()));
        }
        catch (Throwable error) {
            Log.e((String)TAG, (String)("Error during preparing MediaRecorder: " + error.getMessage()));
        }
        this.releaseVideoRecorder();
        return false;
    }

    private void updatePreview(CameraCaptureSession cameraCaptureSession) {
        if (null == this.cameraDevice) {
            return;
        }
        this.captureSession = cameraCaptureSession;
        this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
        this.previewRequest = this.previewRequestBuilder.build();
        try {
            this.captureSession.setRepeatingRequest(this.previewRequest, this.captureCallback, this.backgroundHandler);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error updating preview: ", (Throwable)e);
        }
        this.setFlashModeAndBuildPreviewRequest(this.configurationProvider.getFlashMode());
    }

    private void closePreviewSession() {
        if (this.captureSession != null) {
            this.captureSession.close();
            try {
                this.captureSession.abortCaptures();
            }
            catch (Exception exception) {
            }
            finally {
                this.captureSession = null;
            }
        }
    }

    private void lockFocus() {
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.previewState = 1;
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processCaptureResult(CaptureResult result) {
        switch (this.previewState) {
            case 0: {
                break;
            }
            case 1: {
                Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                if (afState == null) {
                    this.captureStillPicture();
                    break;
                }
                if (4 != afState && 5 != afState && 0 != afState && 1 != afState) break;
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState == null || aeState == 2) {
                    this.previewState = 4;
                    this.captureStillPicture();
                    break;
                }
                this.runPreCaptureSequence();
                break;
            }
            case 2: {
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState != null && aeState != 5 && aeState != 4) break;
                this.previewState = 3;
                break;
            }
            case 3: {
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState != null && aeState == 5) break;
                this.previewState = 4;
                this.captureStillPicture();
                break;
            }
        }
    }

    private void runPreCaptureSequence() {
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.previewState = 2;
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
    }

    private void setFlashModeAndBuildPreviewRequest(int flashMode) {
        try {
            switch (flashMode) {
                case 3: {
                    this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                    this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                    break;
                }
                case 1: {
                    this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                    break;
                }
                case 2: {
                    this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                default: {
                    this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                    this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                }
            }
            this.previewRequest = this.previewRequestBuilder.build();
            try {
                this.captureSession.setRepeatingRequest(this.previewRequest, this.captureCallback, this.backgroundHandler);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error updating preview: ", (Throwable)e);
            }
        }
        catch (Exception ignore) {
            Log.e((String)TAG, (String)"Error setting flash: ", (Throwable)ignore);
        }
    }

    private void captureStillPicture() {
        try {
            if (null == this.cameraDevice) {
                return;
            }
            CaptureRequest.Builder captureBuilder = this.cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.imageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getPhotoOrientation(this.configurationProvider.getSensorPosition()));
            CameraCaptureSession.CaptureCallback CaptureCallback2 = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Log.d((String)Camera2Manager.TAG, (String)"onCaptureCompleted: ");
                }
            };
            this.captureSession.stopRepeating();
            this.captureSession.capture(captureBuilder.build(), CaptureCallback2, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"Error during capturing picture");
        }
    }

    private void unlockFocus() {
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
            this.previewState = 0;
            this.captureSession.setRepeatingRequest(this.previewRequest, this.captureCallback, this.backgroundHandler);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error during focus unlocking");
        }
    }

    public void onImageAvailable(ImageReader imageReader) {
        File outputFile = this.outputPath;
        this.backgroundHandler.post((Runnable)new ImageSaver(imageReader.acquireNextImage(), outputFile, new ImageSaver.ImageSaverCallback(){

            @Override
            public void onSuccessFinish() {
                Log.d((String)Camera2Manager.TAG, (String)"onPhotoSuccessFinish: ");
                if (Camera2Manager.this.cameraPhotoListener != null) {
                    Camera2Manager.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Camera2Manager.this.cameraPhotoListener.onPhotoTaken(Camera2Manager.this.outputPath);
                        }
                    });
                }
                Camera2Manager.this.unlockFocus();
            }

            @Override
            public void onError() {
                Log.d((String)Camera2Manager.TAG, (String)"onPhotoError: ");
                Camera2Manager.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Camera2Manager.this.cameraPhotoListener.onPhotoTakeError();
                    }
                });
            }
        }));
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        if (surfaceTexture != null) {
            this.startPreview(surfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        if (surfaceTexture != null) {
            this.startPreview(surfaceTexture);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

