/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.imageCropper;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtils {
    public static void writeBitmapToFile(Bitmap bm, File file, int quality) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        bm.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    public static Bitmap addPadding(Bitmap bmp, int color) {
        if (bmp == null) {
            return null;
        }
        int biggerParam = Math.max(bmp.getWidth(), bmp.getHeight());
        Bitmap bitmap = Bitmap.createBitmap((int)biggerParam, (int)biggerParam, (Bitmap.Config)bmp.getConfig());
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(color);
        int top = bmp.getHeight() > bmp.getWidth() ? 0 : (bmp.getWidth() - bmp.getHeight()) / 2;
        int left = bmp.getWidth() > bmp.getHeight() ? 0 : (bmp.getHeight() - bmp.getWidth()) / 2;
        canvas.drawBitmap(bmp, (float)left, (float)top, null);
        return bitmap;
    }

    public static Bitmap rotateBitmap(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

