/*
 * Decompiled with CFR 0.152.
 */
package com.sandrios.sandriosCamera.internal.imageCropper;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.sandrios.sandriosCamera.internal.imageCropper.BitmapUtils;
import com.sandrios.sandriosCamera.internal.imageCropper.CropperGridView;
import com.sandrios.sandriosCamera.internal.imageCropper.CropperImageView;
import java.io.File;
import java.io.IOException;

public class CropperView
extends FrameLayout {
    private static final String TAG = "CropperView";
    public CropperImageView mImageView;
    private CropperGridView mGridView;
    private Bitmap mBitmap;
    private boolean isSnappedToCenter = false;
    private boolean gestureEnabled = true;

    public CropperView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CropperView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CropperView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CropperView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int orientation = this.getContext().getResources().getConfiguration().orientation;
        if (orientation == 1 || orientation == 0) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        } else {
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int width = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            this.setMeasuredDimension(width, height);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mImageView = new CropperImageView(context, attrs);
        this.mGridView = new CropperGridView(context, attrs);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, 0);
        if (context.getResources().getConfiguration().orientation == 2) {
            params.width = 0;
            params.height = -1;
        }
        this.addView((View)this.mImageView, 0, (ViewGroup.LayoutParams)params);
        this.addView(this.mGridView, 1, (ViewGroup.LayoutParams)params);
        this.mImageView.setGestureCallback(new TouchGestureCallback());
    }

    public void release() {
        this.mImageView.release();
    }

    public void setImageBitmap(Bitmap bm) {
        this.mImageView.setImageBitmap(bm);
    }

    public void setMaxZoom(float zoom) {
        this.mImageView.setMaxZoom(zoom);
    }

    public Bitmap getCroppedBitmap() {
        return this.mImageView.getCroppedBitmap();
    }

    public boolean isPreScaling() {
        return this.mImageView.isDoPreScaling();
    }

    public void setPreScaling(boolean doPreScaling) {
        this.mImageView.setDoPreScaling(doPreScaling);
    }

    public float getMaxZoom() {
        return this.mImageView.getMaxZoom();
    }

    public float getMinZoom() {
        return this.mImageView.getMinZoom();
    }

    public void setMinZoom(float mMInZoom) {
        this.mImageView.setMinZoom(mMInZoom);
    }

    public void cropToCenter() {
        this.mImageView.cropToCenter();
    }

    public void fitToCenter() {
        this.mImageView.fitToCenter();
    }

    public void setDebug(boolean status) {
        this.mImageView.setDEBUG(status);
    }

    public int getPaddingColor() {
        return this.mImageView.getPaddingColor();
    }

    public void setPaddingColor(int paddingColor) {
        this.mImageView.setPaddingColor(paddingColor);
    }

    public int getCropperWidth() {
        return this.mImageView != null ? this.mImageView.getWidth() : 0;
    }

    public boolean isMakeSquare() {
        return this.mImageView.isMakeSquare();
    }

    public void setMakeSquare(boolean mAddPaddingToMakeSquare) {
        this.mImageView.setMakeSquare(mAddPaddingToMakeSquare);
    }

    public void replaceBitmap(Bitmap bitmap) {
        this.mImageView.replaceBitmap(bitmap);
    }

    public boolean isGestureEnabled() {
        return this.gestureEnabled;
    }

    public void setGestureEnabled(boolean enabled) {
        this.gestureEnabled = enabled;
        this.mImageView.setGestureEnabled(enabled);
    }

    public void loadNewImage(String filePath) {
        Log.i((String)TAG, (String)("load image: " + filePath));
        this.mBitmap = BitmapFactory.decodeFile((String)filePath);
        Log.i((String)TAG, (String)("bitmap: " + this.mBitmap.getWidth() + " " + this.mBitmap.getHeight()));
        int maxP = Math.max(this.mBitmap.getWidth(), this.mBitmap.getHeight());
        float scale1280 = (float)maxP / 1280.0f;
        if (this.mImageView.getWidth() != 0) {
            this.mImageView.setMaxZoom((float)(this.mImageView.getWidth() * 2) / 1280.0f);
        } else {
            ViewTreeObserver vto = this.mImageView.getViewTreeObserver();
            vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    CropperView.this.mImageView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    CropperView.this.mImageView.setMaxZoom((float)(CropperView.this.mImageView.getWidth() * 2) / 1280.0f);
                    return true;
                }
            });
        }
        this.mBitmap = Bitmap.createScaledBitmap((Bitmap)this.mBitmap, (int)((int)((float)this.mBitmap.getWidth() / scale1280)), (int)((int)((float)this.mBitmap.getHeight() / scale1280)), (boolean)true);
        this.mImageView.setImageBitmap(this.mBitmap);
    }

    public void cropImage(String filepath) {
        Bitmap bitmap = this.mImageView.getCroppedBitmap();
        if (bitmap != null) {
            try {
                BitmapUtils.writeBitmapToFile(bitmap, new File(filepath), 90);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void rotateImage() {
        if (this.mBitmap == null) {
            Log.e((String)TAG, (String)"bitmap is not loaded yet");
            return;
        }
        this.mBitmap = BitmapUtils.rotateBitmap(this.mBitmap, 90.0f);
        this.mImageView.setImageBitmap(this.mBitmap);
    }

    public void snapImage() {
        if (this.isSnappedToCenter) {
            this.mImageView.cropToCenter();
        } else {
            this.mImageView.fitToCenter();
        }
        this.isSnappedToCenter = !this.isSnappedToCenter;
    }

    private class TouchGestureCallback
    implements CropperImageView.GestureCallback {
        private TouchGestureCallback() {
        }

        @Override
        public void onGestureStarted() {
            CropperView.this.mGridView.setShowGrid(true);
        }

        @Override
        public void onGestureCompleted() {
            CropperView.this.mGridView.setShowGrid(false);
        }
    }
}

